/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class IntentionDescriptionNotFoundInspection
extends DevKitInspectionBase {
    @NonNls
    private static final String INTENTION = "com.intellij.codeInsight.intention.IntentionAction";
    @NonNls
    private static final String INSPECTION_DESCRIPTIONS = "intentionDescriptions";

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "checkClass"));
        }
        Project project = aClass.getProject();
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(aClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(INTENTION, GlobalSearchScope.allScope((Project)project));
        if (base == null || !aClass.isInheritor(base, true)) {
            return null;
        }
        String descriptionDir = IntentionDescriptionNotFoundInspection.getDescriptionDirName(aClass);
        if (StringUtil.isEmptyOrSpaces((String)descriptionDir)) {
            return null;
        }
        for (PsiDirectory description : IntentionDescriptionNotFoundInspection.getIntentionDescriptionsDirs(module)) {
            PsiFile descr;
            PsiDirectory dir = description.findSubdirectory(descriptionDir);
            if (dir == null || (descr = dir.findFile("description.html")) == null) continue;
            if (!IntentionDescriptionNotFoundInspection.hasBeforeAndAfterTemplate(dir.getVirtualFile())) {
                PsiIdentifier problem = aClass.getNameIdentifier();
                ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), "Intention must have 'before.*.template' and 'after.*.template' beside 'description.html'", isOnTheFly, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                return new ProblemDescriptor[]{problemDescriptor};
            }
            return null;
        }
        PsiIdentifier problem = aClass.getNameIdentifier();
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), "Intention does not have a description", isOnTheFly, new LocalQuickFix[]{new CreateHtmlDescriptionFix(descriptionDir, module, true)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    @Nullable
    private static String getDescriptionDirName(PsiClass aClass) {
        String descriptionDir = "";
        for (PsiClass each = aClass; each != null; each = each.getContainingClass()) {
            String name = each.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return null;
            }
            descriptionDir = name + descriptionDir;
        }
        return descriptionDir;
    }

    private static boolean hasBeforeAndAfterTemplate(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "hasBeforeAndAfterTemplate"));
        }
        boolean hasBefore = false;
        boolean hasAfter = false;
        for (VirtualFile file : dir.getChildren()) {
            String name = file.getName();
            if (!name.endsWith(".template")) continue;
            if (name.startsWith("before.")) {
                hasBefore = true;
                continue;
            }
            if (!name.startsWith("after.")) continue;
            hasAfter = true;
        }
        return hasBefore && hasAfter;
    }

    public static PsiDirectory[] getIntentionDescriptionsDirs(Module module) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(INSPECTION_DESCRIPTIONS);
        if (aPackage != null) {
            return aPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Intention Description Checker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "getDisplayName"));
        }
        return "Intention Description Checker";
    }

    @NotNull
    public String getShortName() {
        if ("IntentionDescriptionNotFoundInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "getShortName"));
        }
        return "IntentionDescriptionNotFoundInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

