/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class InspectionDescriptionNotFoundInspection
extends DevKitInspectionBase {
    @NonNls
    static final String INSPECTION_PROFILE_ENTRY = InspectionProfileEntry.class.getName();
    @NonNls
    private static final String INSPECTION_DESCRIPTIONS = "inspectionDescriptions";

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String filename;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "checkClass"));
        }
        Project project = aClass.getProject();
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(aClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(INSPECTION_PROFILE_ENTRY, GlobalSearchScope.allScope((Project)project));
        if (base == null || !aClass.isInheritor(base, true) || InspectionDescriptionNotFoundInspection.isPathMethodsAreOverridden(aClass)) {
            return null;
        }
        PsiMethod method = InspectionDescriptionNotFoundInspection.findNearestMethod("getShortName", aClass);
        if (method != null && method.getContainingClass().getQualifiedName().equals(INSPECTION_PROFILE_ENTRY)) {
            method = null;
        }
        String string = filename = method == null ? InspectionProfileEntry.getShortName((String)aClass.getName()) : PsiUtil.getReturnedLiteral(method, aClass);
        if (filename == null) {
            return null;
        }
        for (PsiDirectory description : InspectionDescriptionNotFoundInspection.getInspectionDescriptionsDirs(module)) {
            VirtualFile vf;
            PsiFile file = description.findFile(filename + ".html");
            if (file == null || (vf = file.getVirtualFile()) == null || !vf.getNameWithoutExtension().equals(filename)) continue;
            return null;
        }
        PsiElement problem = InspectionDescriptionNotFoundInspection.getProblemElement(aClass, method);
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), "Inspection does not have a description", isOnTheFly, new LocalQuickFix[]{new CreateHtmlDescriptionFix(filename, module, false)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    @Nullable
    private static PsiElement getProblemElement(PsiClass aClass, @Nullable PsiMethod method) {
        if (method != null && method.getContainingClass() == aClass) {
            return PsiUtil.getReturnedExpression(method);
        }
        return aClass.getNameIdentifier();
    }

    private static boolean isPathMethodsAreOverridden(PsiClass aClass) {
        return !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getStaticDescription", INSPECTION_PROFILE_ENTRY, aClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionUrl", INSPECTION_PROFILE_ENTRY, aClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionContextClass", INSPECTION_PROFILE_ENTRY, aClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionFileName", INSPECTION_PROFILE_ENTRY, aClass);
    }

    private static boolean isLastMethodDefinitionIn(@NotNull String methodName, @NotNull String classFQN, PsiClass cls) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "isLastMethodDefinitionIn"));
        }
        if (classFQN == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "isLastMethodDefinitionIn"));
        }
        if (cls == null) {
            return false;
        }
        for (PsiMethod method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return classFQN.equals(containingClass.getQualifiedName());
        }
        return InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn(methodName, classFQN, cls.getSuperClass());
    }

    public static PsiDirectory[] getInspectionDescriptionsDirs(Module module) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(INSPECTION_DESCRIPTIONS);
        if (aPackage != null) {
            return aPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiMethod findNearestMethod(String name, @Nullable PsiClass cls) {
        if (cls == null) {
            return null;
        }
        for (PsiMethod method : cls.getMethods()) {
            if (method.getParameterList().getParametersCount() != 0 || !method.getName().equals(name)) continue;
            return method.getModifierList().hasModifierProperty("abstract") ? null : method;
        }
        return InspectionDescriptionNotFoundInspection.findNearestMethod(name, cls.getSuperClass());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Inspection Description Checker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "getDisplayName"));
        }
        return "Inspection Description Checker";
    }

    @NotNull
    public String getShortName() {
        if ("InspectionDescriptionNotFoundInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection", "getShortName"));
        }
        return "InspectionDescriptionNotFoundInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

