/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterActionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterComponentFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ComponentType;

public class ComponentNotRegisteredInspection
extends DevKitInspectionBase {
    public boolean CHECK_ACTIONS = true;
    public boolean IGNORE_NON_PUBLIC = true;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.devkit.inspections.ComponentNotRegisteredInspection");

    @NotNull
    public String getDisplayName() {
        String string = DevKitBundle.message("inspections.component.not.registered.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("ComponentNotRegistered" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection", "getShortName"));
        }
        return "ComponentNotRegistered";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final JCheckBox ignoreNonPublic = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.ignore.non.public", new Object[0]), this.IGNORE_NON_PUBLIC);
        ignoreNonPublic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ComponentNotRegisteredInspection.this.IGNORE_NON_PUBLIC = ignoreNonPublic.isSelected();
            }
        });
        final JCheckBox checkJavaActions = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.check.actions", new Object[0]), this.CHECK_ACTIONS);
        checkJavaActions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected;
                ComponentNotRegisteredInspection.this.CHECK_ACTIONS = selected = checkJavaActions.isSelected();
                ignoreNonPublic.setEnabled(selected);
            }
        });
        jPanel.add(checkJavaActions);
        jPanel.add(ignoreNonPublic);
        return jPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass checkedClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (checkedClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection", "checkClass"));
        }
        PsiFile psiFile = checkedClass.getContainingFile();
        PsiIdentifier classIdentifier = checkedClass.getNameIdentifier();
        if (checkedClass.getQualifiedName() != null && classIdentifier != null && psiFile != null && psiFile.getVirtualFile() != null && !ComponentNotRegisteredInspection.isAbstract((PsiModifierListOwner)checkedClass)) {
            ComponentType[] types;
            if (PsiUtil.isInnerClass((PsiClass)checkedClass)) {
                return null;
            }
            PsiManager psiManager = checkedClass.getManager();
            GlobalSearchScope scope = checkedClass.getResolveScope();
            if (this.CHECK_ACTIONS) {
                PsiClass actionClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(AnAction.class.getName(), scope);
                if (actionClass == null) {
                    return null;
                }
                if (checkedClass.isInheritor(actionClass, true)) {
                    if (this.IGNORE_NON_PUBLIC && !ComponentNotRegisteredInspection.isPublic((PsiModifierListOwner)checkedClass)) {
                        return null;
                    }
                    if (!ComponentNotRegisteredInspection.isActionRegistered(checkedClass) && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                        RegisterActionFix fix = new RegisterActionFix(checkedClass);
                        ProblemDescriptor problem = manager.createProblemDescriptor((PsiElement)classIdentifier, DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message("new.menu.action.text", new Object[0])), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                        return new ProblemDescriptor[]{problem};
                    }
                    return null;
                }
            }
            for (ComponentType type : types = ComponentType.values()) {
                PsiClass compClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(type.myClassName, scope);
                if (compClass == null) {
                    return null;
                }
                if (!checkedClass.isInheritor(compClass, true)) continue;
                if (ComponentNotRegisteredInspection.getRegistrationTypes(checkedClass, false) == null && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                    RegisterComponentFix fix = new RegisterComponentFix(type, checkedClass);
                    ProblemDescriptor problem = manager.createProblemDescriptor((PsiElement)classIdentifier, DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message(type.myPropertyKey, new Object[0])), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    return new ProblemDescriptor[]{problem};
                }
                return null;
            }
        }
        return null;
    }

    private static boolean canFix(PsiClass psiClass) {
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        return PluginModuleType.isPluginModuleOrDependency(module);
    }
}

