/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class IdeaPluginConverter
extends ResolvingConverter<IdeaPlugin> {
    private static final Condition<IdeaPlugin> NON_CORE_PLUGINS = new Condition<IdeaPlugin>(){

        public boolean value(IdeaPlugin plugin) {
            return !"com.intellij".equals(plugin.getPluginId());
        }
    };

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPluginsWithoutSelf(context);
        List list = ContainerUtil.filter(plugins, NON_CORE_PLUGINS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter", "getVariants"));
        }
        return list;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter", "getAdditionalVariants"));
        }
        THashSet result = new THashSet();
        for (IdeaPlugin ideaPlugin : IdeaPluginConverter.getAllPluginsWithoutSelf(context)) {
            for (PluginModule module : ideaPlugin.getModules()) {
                ContainerUtil.addIfNotNull((Object)module.getValue().getValue(), (Collection)result);
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter", "getAdditionalVariants"));
        }
        return tHashSet;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return DevKitBundle.message("error.cannot.resolve.plugin", s);
    }

    public IdeaPlugin fromString(@Nullable @NonNls String s, ConvertContext context) {
        for (IdeaPlugin ideaPlugin : IdeaPluginConverter.getAllPluginsWithoutSelf(context)) {
            String otherId = ideaPlugin.getPluginId();
            if (otherId == null) continue;
            if (otherId.equals(s)) {
                return ideaPlugin;
            }
            for (PluginModule module : ideaPlugin.getModules()) {
                String moduleName = (String)module.getValue().getValue();
                if (moduleName == null || !moduleName.equals(s)) continue;
                return ideaPlugin;
            }
        }
        return null;
    }

    public String toString(@Nullable IdeaPlugin ideaPlugin, ConvertContext context) {
        return ideaPlugin != null ? ideaPlugin.getPluginId() : null;
    }

    private static Collection<IdeaPlugin> getAllPluginsWithoutSelf(ConvertContext context) {
        final IdeaPlugin self = (IdeaPlugin)context.getInvocationElement().getParentOfType(IdeaPlugin.class, true);
        if (self == null) {
            return Collections.emptyList();
        }
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPlugins(context.getProject());
        return ContainerUtil.filter(plugins, (Condition)new Condition<IdeaPlugin>(){

            public boolean value(IdeaPlugin plugin) {
                return !Comparing.strEqual((String)self.getPluginId(), (String)plugin.getPluginId());
            }
        });
    }

    public static Collection<IdeaPlugin> getAllPlugins(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = PsiUtil.isIdeaProject(project) ? GlobalSearchScopesCore.projectProductionScope((Project)project) : GlobalSearchScope.allScope((Project)project);
        List files = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
        return ContainerUtil.map((Collection)files, (Function)new Function<DomFileElement<IdeaPlugin>, IdeaPlugin>(){

            public IdeaPlugin fun(DomFileElement<IdeaPlugin> ideaPluginDomFileElement) {
                return (IdeaPlugin)ideaPluginDomFileElement.getRootElement();
            }
        });
    }
}

