/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildParticipant;
import org.jetbrains.idea.devkit.module.PluginDescriptorConstants;

public class PluginBuildConfiguration
implements ModuleComponent,
JDOMExternalizable {
    private final Module myModule;
    private final ConfigFileContainer myPluginXmlContainer;
    private VirtualFilePointer myManifestFilePointer;
    private boolean myUseUserManifest = false;
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String MANIFEST_ATTR = "manifest";
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";
    private final PluginBuildParticipant myBuildParticipant;

    public PluginBuildConfiguration(Module module) {
        this.myModule = module;
        this.myPluginXmlContainer = ConfigFileFactory.getInstance().createSingleFileContainer(this.myModule.getProject(), PluginDescriptorConstants.META_DATA);
        Disposer.register((Disposable)module, (Disposable)this.myPluginXmlContainer);
        this.myBuildParticipant = new PluginBuildParticipant(module, this);
    }

    @Nullable
    public static PluginBuildConfiguration getInstance(Module module) {
        return (PluginBuildConfiguration)module.getComponent(PluginBuildConfiguration.class);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
    }

    @NotNull
    public String getComponentName() {
        if ("DevKit.ModuleBuildProperties" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "getComponentName"));
        }
        return "DevKit.ModuleBuildProperties";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        String url = element.getAttributeValue(URL_ATTR);
        if (url != null) {
            this.myPluginXmlContainer.getConfiguration().replaceConfigFile(PluginDescriptorConstants.META_DATA, url);
        }
        if ((url = element.getAttributeValue(MANIFEST_ATTR)) != null) {
            this.setManifestPath(VfsUtilCore.urlToPath((String)url));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String url = this.getPluginXmlUrl();
        if (url != null) {
            element.setAttribute(URL_ATTR, url);
        }
        if (this.myManifestFilePointer != null) {
            element.setAttribute(MANIFEST_ATTR, this.myManifestFilePointer.getUrl());
        }
    }

    @Nullable
    public ConfigFile getPluginXML() {
        return this.myPluginXmlContainer.getConfigFile(PluginDescriptorConstants.META_DATA);
    }

    private void createDescriptor(String url) {
        ConfigFileInfo descriptor = new ConfigFileInfo(PluginDescriptorConstants.META_DATA, url);
        this.myPluginXmlContainer.getConfiguration().addConfigFile(descriptor);
        ConfigFileFactory.getInstance().createFile(this.myModule.getProject(), descriptor.getUrl(), PluginDescriptorConstants.META_DATA.getDefaultVersion(), false);
    }

    @Nullable
    public ConfigFile getPluginXmlConfigFile() {
        return this.myPluginXmlContainer.getConfigFile(PluginDescriptorConstants.META_DATA);
    }

    @Nullable
    private String getPluginXmlUrl() {
        ConfigFile configFile = this.getPluginXmlConfigFile();
        return configFile != null ? configFile.getUrl() : null;
    }

    private String getDefaultLocation() {
        return new File(this.myModule.getModuleFilePath()).getParent() + File.separator + META_INF + File.separator + PLUGIN_XML;
    }

    @NotNull
    public String getPluginXmlPath() {
        String url = this.getPluginXmlUrl();
        if (url == null) {
            String string = this.getDefaultLocation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "getPluginXmlPath"));
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/build/PluginBuildConfiguration", "getPluginXmlPath"));
        }
        return string;
    }

    public void setPluginXmlPathAndCreateDescriptorIfDoesntExist(final String pluginXmlPath) {
        this.myPluginXmlContainer.getConfiguration().removeConfigFiles(new ConfigFileMetaData[]{PluginDescriptorConstants.META_DATA});
        new WriteAction(){

            protected void run(Result result) throws Throwable {
                PluginBuildConfiguration.this.createDescriptor(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)pluginXmlPath)));
            }
        }.execute();
    }

    public void setManifestPath(final String manifestPath) {
        if (manifestPath == null || manifestPath.length() == 0) {
            this.myManifestFilePointer = null;
        } else {
            final VirtualFile manifest = LocalFileSystem.getInstance().findFileByPath(manifestPath);
            if (manifest == null) {
                Messages.showErrorDialog((Project)this.myModule.getProject(), (String)DevKitBundle.message("error.file.not.found.message", manifestPath), (String)DevKitBundle.message("error.file.not.found", new Object[0]));
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PluginBuildConfiguration.this.myManifestFilePointer = VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)manifestPath)), (Disposable)PluginBuildConfiguration.this.myModule, null);
                    }
                });
            } else {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PluginBuildConfiguration.this.myManifestFilePointer = VirtualFilePointerManager.getInstance().create(manifest, (Disposable)PluginBuildConfiguration.this.myModule, null);
                    }
                });
            }
        }
    }

    @Nullable
    public String getManifestPath() {
        if (this.myManifestFilePointer != null) {
            return FileUtil.toSystemDependentName((String)this.myManifestFilePointer.getPresentableUrl());
        }
        return null;
    }

    @Nullable
    public VirtualFile getManifest() {
        if (this.myManifestFilePointer != null) {
            return this.myManifestFilePointer.getFile();
        }
        return null;
    }

    public boolean isUseUserManifest() {
        return this.myUseUserManifest;
    }

    public void setUseUserManifest(boolean useUserManifest) {
        this.myUseUserManifest = useUserManifest;
    }

    public PluginBuildParticipant getBuildParticipant() {
        return this.myBuildParticipant;
    }
}

