/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.PlatformDependent0;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;

public final class MpscLinkedQueue<T>
extends AtomicReference<Node<T>>
implements Queue<T> {
    private static final long tailOffset;
    private volatile Node<T> tail;

    MpscLinkedQueue() {
        DefaultNode<Object> task = new DefaultNode<Object>(null);
        this.tail = task;
        this.set(task);
    }

    @Override
    public boolean add(T value) {
        if (value instanceof Node) {
            Node node = (Node)value;
            node.setNext(null);
            this.getAndSet(node).setNext(node);
        } else {
            DefaultNode<T> n = new DefaultNode<T>(value);
            ((Node)this.getAndSet(n)).setNext(n);
        }
        return true;
    }

    @Override
    public boolean offer(T value) {
        return this.add(value);
    }

    @Override
    public T remove() {
        T v = this.poll();
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    @Override
    public T poll() {
        Node<T> next = this.peekNode();
        if (next == null) {
            return null;
        }
        Node<T> ret = next;
        PlatformDependent.putOrderedObject(this, tailOffset, next);
        return ret.value();
    }

    @Override
    public T element() {
        Node<T> next = this.peekNode();
        if (next == null) {
            throw new NoSuchElementException();
        }
        return next.value();
    }

    @Override
    public T peek() {
        Node<T> next = this.peekNode();
        if (next == null) {
            return null;
        }
        return next.value();
    }

    @Override
    public int size() {
        int count = 0;
        for (Node<T> n = this.peekNode(); n != null; n = n.next()) {
            ++count;
        }
        return count;
    }

    private Node<T> peekNode() {
        Node tail;
        Node next;
        while ((next = (tail = (Node)PlatformDependent.getObjectVolatile(this, tailOffset)).next()) == null && this.get() != tail) {
        }
        return next;
    }

    @Override
    public boolean isEmpty() {
        return this.peek() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (Node<T> n = this.peekNode(); n != null; n = n.next()) {
            if (n.value() != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T r : c) {
            this.add(r);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    static {
        try {
            tailOffset = PlatformDependent.objectFieldOffset(MpscLinkedQueue.class.getDeclaredField("tail"));
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }

    public static abstract class Node<T> {
        private static final long nextOffset;
        private volatile Node<T> tail;

        final Node<T> next() {
            return (Node)PlatformDependent.getObjectVolatile(this, nextOffset);
        }

        final void setNext(Node<T> newNext) {
            PlatformDependent.putOrderedObject(this, nextOffset, newNext);
        }

        public abstract T value();

        static {
            if (PlatformDependent0.hasUnsafe()) {
                try {
                    nextOffset = PlatformDependent.objectFieldOffset(Node.class.getDeclaredField("tail"));
                }
                catch (Throwable t) {
                    throw new ExceptionInInitializerError(t);
                }
            } else {
                nextOffset = -1L;
            }
        }
    }

    private static final class DefaultNode<T>
    extends Node<T> {
        private final T value;

        DefaultNode(T value) {
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }
    }
}

