/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.memcache.AbstractMemcacheObjectAggregator;
import io.netty.handler.codec.memcache.FullMemcacheMessage;
import io.netty.handler.codec.memcache.LastMemcacheContent;
import io.netty.handler.codec.memcache.MemcacheContent;
import io.netty.handler.codec.memcache.MemcacheMessage;
import io.netty.handler.codec.memcache.MemcacheObject;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import java.util.List;

public class BinaryMemcacheObjectAggregator
extends AbstractMemcacheObjectAggregator {
    private boolean tooLongFrameFound;

    public BinaryMemcacheObjectAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, MemcacheObject msg, List<Object> out) throws Exception {
        FullMemcacheMessage currentMessage = this.currentMessage;
        if (msg instanceof MemcacheMessage) {
            this.tooLongFrameFound = false;
            MemcacheMessage m = (MemcacheMessage)msg;
            if (!m.getDecoderResult().isSuccess()) {
                out.add(BinaryMemcacheObjectAggregator.toFullMessage(m));
                this.currentMessage = null;
                return;
            }
            if (msg instanceof BinaryMemcacheRequest) {
                this.currentMessage = BinaryMemcacheObjectAggregator.toFullRequest((BinaryMemcacheRequest)msg, Unpooled.compositeBuffer(this.getMaxCumulationBufferComponents()));
                return;
            } else {
                if (!(msg instanceof BinaryMemcacheResponse)) throw new Error();
                this.currentMessage = BinaryMemcacheObjectAggregator.toFullResponse((BinaryMemcacheResponse)msg, Unpooled.compositeBuffer(this.getMaxCumulationBufferComponents()));
            }
            return;
        } else {
            boolean last;
            if (!(msg instanceof MemcacheContent)) throw new Error();
            if (this.tooLongFrameFound) {
                if (!(msg instanceof LastMemcacheContent)) return;
                this.currentMessage = null;
                return;
            }
            MemcacheContent chunk = (MemcacheContent)msg;
            CompositeByteBuf content = (CompositeByteBuf)currentMessage.content();
            if (content.readableBytes() > this.getMaxContentLength() - chunk.content().readableBytes()) {
                this.tooLongFrameFound = true;
                currentMessage.release();
                this.currentMessage = null;
                throw new TooLongFrameException("Memcache content length exceeded " + this.getMaxContentLength() + " bytes.");
            }
            if (chunk.content().isReadable()) {
                chunk.retain();
                content.addComponent(chunk.content());
                content.writerIndex(content.writerIndex() + chunk.content().readableBytes());
            }
            if (!chunk.getDecoderResult().isSuccess()) {
                currentMessage.setDecoderResult(DecoderResult.failure(chunk.getDecoderResult().cause()));
                last = true;
            } else {
                last = chunk instanceof LastMemcacheContent;
            }
            if (!last) return;
            this.currentMessage = null;
            out.add(currentMessage);
        }
    }

    private static FullMemcacheMessage toFullMessage(MemcacheMessage msg) {
        BinaryMemcacheMessage fullMsg;
        if (msg instanceof FullMemcacheMessage) {
            return ((FullMemcacheMessage)msg).retain();
        }
        if (msg instanceof BinaryMemcacheRequest) {
            fullMsg = BinaryMemcacheObjectAggregator.toFullRequest((BinaryMemcacheRequest)msg, Unpooled.EMPTY_BUFFER);
        } else if (msg instanceof BinaryMemcacheResponse) {
            fullMsg = BinaryMemcacheObjectAggregator.toFullResponse((BinaryMemcacheResponse)msg, Unpooled.EMPTY_BUFFER);
        } else {
            throw new IllegalStateException();
        }
        return fullMsg;
    }

    private static FullBinaryMemcacheRequest toFullRequest(BinaryMemcacheRequest request, ByteBuf content) {
        DefaultFullBinaryMemcacheRequest fullRequest = new DefaultFullBinaryMemcacheRequest(request.getKey(), request.getExtras(), content);
        fullRequest.setMagic(request.getMagic());
        fullRequest.setOpcode(request.getOpcode());
        fullRequest.setKeyLength(request.getKeyLength());
        fullRequest.setExtrasLength(request.getExtrasLength());
        fullRequest.setDataType(request.getDataType());
        fullRequest.setTotalBodyLength(request.getTotalBodyLength());
        fullRequest.setOpaque(request.getOpaque());
        fullRequest.setCAS(request.getCAS());
        fullRequest.setReserved(request.getReserved());
        return fullRequest;
    }

    private static FullBinaryMemcacheResponse toFullResponse(BinaryMemcacheResponse response, ByteBuf content) {
        DefaultFullBinaryMemcacheResponse fullResponse = new DefaultFullBinaryMemcacheResponse(response.getKey(), response.getExtras(), content);
        fullResponse.setMagic(response.getMagic());
        fullResponse.setOpcode(response.getOpcode());
        fullResponse.setKeyLength(response.getKeyLength());
        fullResponse.setExtrasLength(response.getExtrasLength());
        fullResponse.setDataType(response.getDataType());
        fullResponse.setTotalBodyLength(response.getTotalBodyLength());
        fullResponse.setOpaque(response.getOpaque());
        fullResponse.setCAS(response.getCAS());
        fullResponse.setStatus(response.getStatus());
        return fullResponse;
    }
}

