/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.openapi.util.ActionCallback;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.rpc.AsyncResultCallbackBase;
import org.jetbrains.rpc.ErrorConsumer;
import org.jetbrains.rpc.MessageManager;
import org.jetbrains.rpc.ResultReader;

abstract class CommandCallbackWithResponseBase<SUCCESS_RESPONSE, C extends ActionCallback, RESULT, ERROR_DETAILS>
extends AsyncResultCallbackBase<SUCCESS_RESPONSE, C, ERROR_DETAILS> {
    private final String methodName;

    public CommandCallbackWithResponseBase(C callback, String methodName, @Nullable ErrorConsumer<C, ERROR_DETAILS> errorConsumer) {
        super(callback, errorConsumer);
        this.methodName = methodName;
    }

    @Override
    public final void onSuccess(SUCCESS_RESPONSE response, ResultReader<SUCCESS_RESPONSE> resultReader) {
        try {
            this.onSuccess(resultReader.readResult(this.methodName, response));
        }
        catch (Throwable e) {
            this.callback.reject(e.getMessage());
            MessageManager.LOG.error(e);
        }
    }

    protected abstract void onSuccess(RESULT var1);
}

