/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;
import org.jetbrains.lang.manifest.ManifestLanguage;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.Section;

public class ManifestFileImpl
extends PsiFileBase
implements ManifestFile {
    public ManifestFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, ManifestLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = ManifestFileTypeFactory.MANIFEST;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/psi/impl/ManifestFileImpl", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public List<Section> getSections() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, Section.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/psi/impl/ManifestFileImpl", "getSections"));
        }
        return list;
    }

    @Override
    @Nullable
    public Section getMainSection() {
        return this.findChildByClass(Section.class);
    }

    @Override
    @NotNull
    public List<Header> getHeaders() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this.getFirstChild(), Header.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/psi/impl/ManifestFileImpl", "getHeaders"));
        }
        return list;
    }

    @Override
    @Nullable
    public Header getHeader(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/psi/impl/ManifestFileImpl", "getHeader"));
        }
        Header child = (Header)PsiTreeUtil.findChildOfType((PsiElement)this.getFirstChild(), Header.class);
        while (child != null) {
            if (name.equals(child.getName())) {
                return child;
            }
            child = (Header)PsiTreeUtil.getNextSiblingOfType((PsiElement)child, Header.class);
        }
        return null;
    }

    @Override
    public String toString() {
        return "ManifestFile:" + this.getName();
    }
}

