/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.jetbrains.lang.manifest.psi.Section;

public class MissingFinalNewlineInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String text;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection", "checkFile"));
        }
        if (file instanceof ManifestFile && (text = file.getText()) != null && text.length() > 0 && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            List<Section> sections = ((ManifestFile)file).getSections();
            assert (sections.size() > 0) : text;
            Section section = sections.get(sections.size() - 1);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(section.getLastChild(), ManifestBundle.message("inspection.newline.message", new Object[0]), (LocalQuickFix)new AddNewlineQuickFix(section), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private static class AddNewlineQuickFix
    implements LocalQuickFix {
        private final Section mySection;

        private AddNewlineQuickFix(Section section) {
            this.mySection = section;
        }

        @NotNull
        public String getName() {
            String string = ManifestBundle.message("inspection.newline.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = ManifestBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/lang/manifest/highlighting/MissingFinalNewlineInspection$AddNewlineQuickFix", "applyFix"));
            }
            PsiElement lastChild = this.mySection.getLastChild();
            if (lastChild instanceof Header) {
                lastChild.getNode().addLeaf((IElementType)ManifestTokenType.NEWLINE, (CharSequence)"\n", null);
            }
        }
    }
}

