/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.parser.ManifestParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestElementType;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class StandardHeaderParser
implements HeaderParser {
    public static final HeaderParser INSTANCE = new StandardHeaderParser();

    @Override
    public void parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/StandardHeaderParser", "parse"));
        }
        PsiBuilder.Marker marker = builder.mark();
        while (!builder.eof() && !ManifestParser.HEADER_END_TOKENS.contains(builder.getTokenType())) {
            IElementType lastToken = builder.getTokenType();
            builder.advanceLexer();
            if (lastToken != ManifestTokenType.NEWLINE || builder.getTokenType() == ManifestTokenType.SIGNIFICANT_SPACE) continue;
            break;
        }
        marker.done(ManifestElementType.HEADER_VALUE_PART);
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/StandardHeaderParser", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/lang/manifest/header/impl/StandardHeaderParser", "annotate"));
        }
        return false;
    }

    @Override
    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/StandardHeaderParser", "getConvertedValue"));
        }
        HeaderValue value = header.getHeaderValue();
        return value != null ? value.getUnwrappedText() : null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        if (headerValuePart == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/lang/manifest/header/impl/StandardHeaderParser", "getReferences"));
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/header/impl/StandardHeaderParser", "getReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

