/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.facet;

import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.facet.FacetState;

public abstract class JpsFacetConfigurationSerializer<E extends JpsElement> {
    private final JpsElementChildRole<E> myRole;
    private final String myFacetTypeId;
    private final String myFacetName;

    public JpsFacetConfigurationSerializer(JpsElementChildRole<E> role, String facetTypeId, @Nullable String facetName) {
        this.myRole = role;
        this.myFacetTypeId = facetTypeId;
        this.myFacetName = facetName;
    }

    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    public E loadExtension(Element configurationElement, String facetName, JpsModule module, JpsElement parentFacet) {
        E e = this.loadExtension(configurationElement, facetName, parentFacet, module);
        return (E)module.getContainer().setChild(this.myRole, e);
    }

    protected abstract E loadExtension(@NotNull Element var1, String var2, JpsElement var3, JpsModule var4);

    public boolean hasExtension(JpsModule module) {
        return module.getContainer().getChild(this.myRole) != null;
    }

    public void saveExtension(JpsModule module, @NotNull List<FacetState> states) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/serialization/facet/JpsFacetConfigurationSerializer", "saveExtension"));
        }
        JpsElement extension = module.getContainer().getChild(this.myRole);
        if (extension != null) {
            FacetState state = new FacetState();
            state.setFacetType(this.myFacetTypeId);
            state.setName(this.myFacetName);
            Element tag = new Element("configuration");
            this.saveExtension(extension, tag, module);
            state.setConfiguration(tag);
            states.add(state);
        }
    }

    protected abstract void saveExtension(E var1, Element var2, JpsModule var3);
}

