/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsModuleSourceRootImpl<P extends JpsElement>
extends JpsCompositeElementBase<JpsModuleSourceRootImpl<P>>
implements JpsTypedModuleSourceRoot<P> {
    private final JpsModuleSourceRootType<P> myRootType;
    private final String myUrl;

    public JpsModuleSourceRootImpl(String url, JpsModuleSourceRootType<P> type, P properties) {
        this.myRootType = type;
        this.myContainer.setChild(type.getPropertiesRole(), properties);
        this.myUrl = url;
    }

    private JpsModuleSourceRootImpl(JpsModuleSourceRootImpl<P> original) {
        super(original);
        this.myRootType = original.myRootType;
        this.myUrl = original.myUrl;
    }

    public <P extends JpsElement> P getProperties(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "getProperties"));
        }
        if (this.myRootType.equals(type)) {
            return (P)this.myContainer.getChild(this.myRootType.getPropertiesRole());
        }
        return null;
    }

    @Nullable
    public <P extends JpsElement> P getProperties(@NotNull Set<? extends JpsModuleSourceRootType<P>> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "getProperties"));
        }
        if (types.contains(this.myRootType)) {
            return this.getProperties();
        }
        return null;
    }

    @Nullable
    public <P extends JpsElement> JpsTypedModuleSourceRoot<P> asTyped(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "asTyped"));
        }
        return this.myRootType.equals(type) ? this : null;
    }

    @NotNull
    public JpsTypedModuleSourceRoot<?> asTyped() {
        JpsModuleSourceRootImpl jpsModuleSourceRootImpl = this;
        if (jpsModuleSourceRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "asTyped"));
        }
        return jpsModuleSourceRootImpl;
    }

    public JpsElementType<?> getType() {
        return this.myRootType;
    }

    @NotNull
    public P getProperties() {
        JpsElement jpsElement = this.myContainer.getChild(this.myRootType.getPropertiesRole());
        if (jpsElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "getProperties"));
        }
        return (P)jpsElement;
    }

    @NotNull
    public JpsModuleSourceRootType<P> getRootType() {
        JpsModuleSourceRootType<P> jpsModuleSourceRootType = this.myRootType;
        if (jpsModuleSourceRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "getRootType"));
        }
        return jpsModuleSourceRootType;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "getUrl"));
        }
        return string;
    }

    @NotNull
    public File getFile() {
        File file = JpsPathUtil.urlToFile((String)this.myUrl);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "getFile"));
        }
        return file;
    }

    @NotNull
    public JpsModuleSourceRootImpl<P> createCopy() {
        JpsModuleSourceRootImpl<P> jpsModuleSourceRootImpl = new JpsModuleSourceRootImpl<P>(this);
        if (jpsModuleSourceRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsModuleSourceRootImpl", "createCopy"));
        }
        return jpsModuleSourceRootImpl;
    }
}

