/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;

public class JpsLibraryRootImpl
extends JpsElementBase<JpsLibraryRootImpl>
implements JpsLibraryRoot {
    private final String myUrl;
    private final JpsOrderRootType myRootType;
    private final JpsLibraryRoot.InclusionOptions myOptions;

    public JpsLibraryRootImpl(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "<init>"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "<init>"));
        }
        this.myUrl = url;
        this.myRootType = rootType;
        this.myOptions = options;
    }

    public JpsLibraryRootImpl(JpsLibraryRootImpl original) {
        this.myUrl = original.myUrl;
        this.myRootType = original.myRootType;
        this.myOptions = original.myOptions;
    }

    @NotNull
    public JpsOrderRootType getRootType() {
        JpsOrderRootType jpsOrderRootType = this.myRootType;
        if (jpsOrderRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "getRootType"));
        }
        return jpsOrderRootType;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "getUrl"));
        }
        return string;
    }

    @NotNull
    public JpsLibraryRoot.InclusionOptions getInclusionOptions() {
        JpsLibraryRoot.InclusionOptions inclusionOptions = this.myOptions;
        if (inclusionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "getInclusionOptions"));
        }
        return inclusionOptions;
    }

    @NotNull
    public JpsLibraryRootImpl createCopy() {
        JpsLibraryRootImpl jpsLibraryRootImpl = new JpsLibraryRootImpl(this);
        if (jpsLibraryRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "createCopy"));
        }
        return jpsLibraryRootImpl;
    }

    public void applyChanges(@NotNull JpsLibraryRootImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "applyChanges"));
        }
    }

    @NotNull
    public JpsLibrary getLibrary() {
        JpsLibrary jpsLibrary = (JpsLibrary)this.myParent.getParent();
        if (jpsLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryRootImpl", "getLibrary"));
        }
        return jpsLibrary;
    }
}

