/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactReference;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.ex.JpsComplexPackagingElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public class JpsArtifactOutputPackagingElementImpl
extends JpsComplexPackagingElementBase<JpsArtifactOutputPackagingElementImpl>
implements JpsArtifactOutputPackagingElement {
    private static final JpsElementChildRole<JpsArtifactReference> ARTIFACT_REFERENCE_CHILD_ROLE = JpsElementChildRoleBase.create((String)"artifact reference");

    public JpsArtifactOutputPackagingElementImpl(@NotNull JpsArtifactReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/model/artifact/impl/elements/JpsArtifactOutputPackagingElementImpl", "<init>"));
        }
        this.myContainer.setChild(ARTIFACT_REFERENCE_CHILD_ROLE, (JpsElement)reference);
    }

    private JpsArtifactOutputPackagingElementImpl(JpsArtifactOutputPackagingElementImpl original) {
        super((JpsComplexPackagingElementBase)original);
    }

    @NotNull
    public JpsArtifactOutputPackagingElementImpl createCopy() {
        JpsArtifactOutputPackagingElementImpl jpsArtifactOutputPackagingElementImpl = new JpsArtifactOutputPackagingElementImpl(this);
        if (jpsArtifactOutputPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsArtifactOutputPackagingElementImpl", "createCopy"));
        }
        return jpsArtifactOutputPackagingElementImpl;
    }

    @NotNull
    public JpsArtifactReference getArtifactReference() {
        JpsArtifactReference jpsArtifactReference = (JpsArtifactReference)this.myContainer.getChild(ARTIFACT_REFERENCE_CHILD_ROLE);
        if (jpsArtifactReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsArtifactOutputPackagingElementImpl", "getArtifactReference"));
        }
        return jpsArtifactReference;
    }

    public List<JpsPackagingElement> getSubstitution() {
        JpsArtifact artifact = (JpsArtifact)this.getArtifactReference().resolve();
        if (artifact == null) {
            return Collections.emptyList();
        }
        JpsCompositePackagingElement rootElement = artifact.getRootElement();
        if (rootElement instanceof JpsArtifactRootElement) {
            return new ArrayList<JpsPackagingElement>(rootElement.getChildren());
        }
        return Collections.singletonList(rootElement);
    }
}

