/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.JZlibEncoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.security.KeyStore;
import java.security.Security;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BinaryRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.NettyUtil;

@ChannelHandler.Sharable
class PortUnificationServerHandler
extends Decoder {
    private static final AtomicNotNullLazyValue<SSLContext> SSL_SERVER_CONTEXT = new AtomicNotNullLazyValue<SSLContext>(){

        @NotNull
        protected SSLContext compute() {
            SSLContext sSLContext;
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                char[] password = "jetbrains".toCharArray();
                ks.load(((Object)((Object)this)).getClass().getResourceAsStream("cert.jks"), password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks, password);
                SSLContext serverContext = SSLContext.getInstance("TLS");
                serverContext.init(kmf.getKeyManagers(), null, null);
                sSLContext = serverContext;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (sSLContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/PortUnificationServerHandler$1", "compute"));
            }
            return sSLContext;
        }
    };
    private final boolean detectSsl;
    private final boolean detectGzip;
    private final DelegatingHttpRequestHandler delegatingHttpRequestHandler;

    public PortUnificationServerHandler() {
        this(new DelegatingHttpRequestHandler(), true, true);
    }

    private PortUnificationServerHandler(DelegatingHttpRequestHandler delegatingHttpRequestHandler, boolean detectSsl, boolean detectGzip) {
        this.delegatingHttpRequestHandler = delegatingHttpRequestHandler;
        this.detectSsl = detectSsl;
        this.detectGzip = detectGzip;
    }

    @Override
    protected void messageReceived(ChannelHandlerContext context, ByteBuf message) throws Exception {
        ByteBuf buffer = this.getBufferIfSufficient(message, 5, context);
        if (buffer == null) {
            message.release();
        } else {
            this.decode(context, buffer);
        }
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer) throws Exception {
        ChannelPipeline pipeline = context.pipeline();
        if (this.detectSsl && SslHandler.isEncrypted((ByteBuf)buffer)) {
            SSLEngine engine = ((SSLContext)SSL_SERVER_CONTEXT.getValue()).createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(engine), new ChunkedWriteHandler(), new PortUnificationServerHandler(this.delegatingHttpRequestHandler, false, this.detectGzip)});
        } else {
            short magic1 = buffer.getUnsignedByte(buffer.readerIndex());
            short magic2 = buffer.getUnsignedByte(buffer.readerIndex() + 1);
            if (this.detectGzip && magic1 == 31 && magic2 == 139) {
                pipeline.addLast(new ChannelHandler[]{new JZlibEncoder(ZlibWrapper.GZIP), new JdkZlibDecoder(ZlibWrapper.GZIP), new PortUnificationServerHandler(this.delegatingHttpRequestHandler, this.detectSsl, false)});
            } else if (PortUnificationServerHandler.isHttp(magic1, magic2)) {
                NettyUtil.addHttpServerCodec(pipeline);
                pipeline.addLast(new ChannelHandler[]{this.delegatingHttpRequestHandler});
                if (BuiltInServer.LOG.isDebugEnabled()) {
                    pipeline.addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                        public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
                            if (message instanceof HttpResponse) {
                                HttpResponse response = (HttpResponse)message;
                                BuiltInServer.LOG.debug("OUT HTTP: " + response.getStatus().code() + " " + response.headers().get("Content-type"));
                            }
                            super.write(context, message, promise);
                        }
                    }});
                }
            } else if (magic1 == 67 && magic2 == 72) {
                buffer.skipBytes(2);
                pipeline.addLast(new ChannelHandler[]{new CustomHandlerDelegator()});
            } else {
                BuiltInServer.LOG.warn("unknown request, first two bytes " + magic1 + " " + magic2);
                context.close();
            }
        }
        PortUnificationServerHandler.ensureThatExceptionHandlerIsLast(pipeline);
        pipeline.remove((ChannelHandler)this);
        context.fireChannelRead((Object)buffer);
    }

    private static void ensureThatExceptionHandlerIsLast(ChannelPipeline pipeline) {
        ChannelHandler exceptionHandler = ChannelExceptionHandler.getInstance();
        if (pipeline.last() != exceptionHandler || pipeline.context(exceptionHandler) == null) {
            return;
        }
        pipeline.remove(exceptionHandler);
        pipeline.addLast(new ChannelHandler[]{exceptionHandler});
    }

    private static boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private static class CustomHandlerDelegator
    extends Decoder {
        private static final int UUID_LENGTH = 16;

        private CustomHandlerDelegator() {
        }

        @Override
        protected void messageReceived(ChannelHandlerContext context, ByteBuf message) throws Exception {
            ByteBuf buffer = this.getBufferIfSufficient(message, 16, context);
            if (buffer == null) {
                message.release();
            } else {
                UUID uuid = new UUID(buffer.readLong(), buffer.readLong());
                for (BinaryRequestHandler customHandler : (BinaryRequestHandler[])BinaryRequestHandler.EP_NAME.getExtensions()) {
                    if (!uuid.equals(customHandler.getId())) continue;
                    ChannelPipeline pipeline = context.pipeline();
                    pipeline.addLast(new ChannelHandler[]{customHandler.getInboundHandler()});
                    PortUnificationServerHandler.ensureThatExceptionHandlerIsLast(pipeline);
                    pipeline.remove((ChannelHandler)this);
                    context.fireChannelRead((Object)buffer);
                    break;
                }
            }
        }
    }
}

