/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.SystemProperties;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public final class NettyUtil {
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void log(Throwable throwable, Logger log) {
        if (NettyUtil.isAsWarning(throwable)) {
            log.warn(throwable);
        } else {
            log.error(throwable);
        }
    }

    public static Channel connectClient(Bootstrap bootstrap, InetSocketAddress remoteAddress, ActionCallback asyncResult) {
        return NettyUtil.connect(bootstrap, remoteAddress, asyncResult, 20);
    }

    @Nullable
    public static Channel connect(Bootstrap bootstrap, InetSocketAddress remoteAddress, ActionCallback asyncResult, int maxAttemptCount) {
        try {
            Socket socket;
            int attemptCount = 0;
            while (true) {
                try {
                    socket = new Socket(remoteAddress.getAddress(), remoteAddress.getPort());
                }
                catch (IOException e) {
                    if (++attemptCount < maxAttemptCount) {
                        Thread.sleep(attemptCount * 100);
                        continue;
                    }
                    asyncResult.reject("Cannot connect: " + e.getMessage());
                    return null;
                }
                break;
            }
            OioSocketChannel channel = new OioSocketChannel(socket);
            BootstrapUtil.initAndRegister((Channel)channel, bootstrap).awaitUninterruptibly();
            return channel;
        }
        catch (Throwable e) {
            asyncResult.reject("Cannot connect: " + e.getMessage());
            return null;
        }
    }

    private static boolean isAsWarning(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        return throwable instanceof IOException && message.equals("An existing connection was forcibly closed by the remote host") || throwable instanceof ChannelException && message.startsWith("Failed to bind to: ") || throwable instanceof BindException || message.startsWith("Connection reset") || message.equals("Operation timed out") || message.equals("Connection timed out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAndReleaseFactory(Channel channel) {
        EventLoop channelFactory = channel.eventLoop();
        try {
            channel.close().awaitUninterruptibly();
        }
        finally {
            channelFactory.shutdownGracefully();
        }
    }

    public static ServerBootstrap nioServerBootstrap(EventLoopGroup eventLoopGroup) {
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(NioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static Bootstrap nioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static void addHttpServerCodec(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(0xA00000)});
    }

    static {
        if (SystemProperties.getBooleanProperty((String)"io.netty.random.id", (boolean)true)) {
            System.setProperty("io.netty.machineId", "9e43d860");
            System.setProperty("io.netty.processId", Integer.toString(new Random().nextInt(65535)));
        }
    }
}

