/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public class JsonUtil {
    public static <T> List<T> nextList(JsonReaderEx reader) {
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            return Collections.emptyList();
        }
        SmartList list = new SmartList();
        JsonUtil.readListBody(reader, list);
        reader.endArray();
        return list;
    }

    public static Object[] nextArray(JsonReaderEx reader) {
        List<Object> list = JsonUtil.nextList(reader);
        return list.toArray(new Object[list.size()]);
    }

    public static Map<String, Object> nextObject(JsonReaderEx reader) {
        THashMap map = new THashMap();
        reader.beginObject();
        while (reader.hasNext()) {
            map.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        return map;
    }

    @Nullable
    public static Object nextAny(JsonReaderEx reader) {
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(reader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextObject(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public static <T> void readListBody(JsonReaderEx reader, List<T> list) {
        do {
            list.add(JsonUtil.nextAny(reader));
        } while (reader.hasNext());
    }
}

