/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.element;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.generate.tostring.element.Element;
import org.jetbrains.generate.tostring.element.ElementFactory;
import org.jetbrains.generate.tostring.element.FieldElement;
import org.jetbrains.generate.tostring.element.MethodElement;

public class ElementUtils {
    private ElementUtils() {
    }

    public static List<FieldElement> getOnlyAsFieldElements(Collection<PsiMember> members) {
        ArrayList<FieldElement> fieldElementList = new ArrayList<FieldElement>();
        for (PsiMember member : members) {
            if (!(member instanceof PsiField)) continue;
            PsiField field = (PsiField)member;
            FieldElement fe = ElementFactory.newFieldElement(field);
            fieldElementList.add(fe);
        }
        return fieldElementList;
    }

    public static List<MethodElement> getOnlyAsMethodElements(Collection<PsiMember> members) {
        ArrayList<MethodElement> methodElementList = new ArrayList<MethodElement>();
        for (PsiMember member : members) {
            if (!(member instanceof PsiMethod)) continue;
            PsiMethod method = (PsiMethod)member;
            MethodElement me = ElementFactory.newMethodElement(method);
            methodElementList.add(me);
        }
        return methodElementList;
    }

    public static List<Element> getOnlyAsFieldAndMethodElements(Collection<PsiMember> members) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (PsiMember member : members) {
            if (member instanceof PsiField) {
                PsiField field = (PsiField)member;
                FieldElement fe = ElementFactory.newFieldElement(field);
                elementList.add(fe);
                continue;
            }
            if (!(member instanceof PsiMethod)) continue;
            PsiMethod method = (PsiMethod)member;
            MethodElement me = ElementFactory.newMethodElement(method);
            elementList.add(me);
        }
        return elementList;
    }
}

