/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.config.ConflictResolutionPolicy;
import org.jetbrains.generate.tostring.config.InsertAtCaretStrategy;
import org.jetbrains.generate.tostring.config.InsertNewMethodStrategy;

public class DuplicatePolicy
implements ConflictResolutionPolicy {
    private static final DuplicatePolicy instance = new DuplicatePolicy();
    private InsertNewMethodStrategy newMethodStrategy = InsertAtCaretStrategy.getInstance();

    private DuplicatePolicy() {
    }

    public static DuplicatePolicy getInstance() {
        return instance;
    }

    @Override
    public void setNewMethodStrategy(InsertNewMethodStrategy strategy) {
        this.newMethodStrategy = strategy;
    }

    @Override
    public PsiMethod applyMethod(PsiClass clazz, PsiMethod existingMethod, @NotNull PsiMethod newMethod, Editor editor) {
        if (newMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/generate/tostring/config/DuplicatePolicy", "applyMethod"));
        }
        return this.newMethodStrategy.insertNewMethod(clazz, newMethod, editor);
    }

    public String toString() {
        return "Duplicate";
    }
}

