/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring;

import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.config.FilterPattern;
import org.jetbrains.generate.tostring.exception.GenerateCodeException;
import org.jetbrains.generate.tostring.exception.PluginException;
import org.jetbrains.generate.tostring.psi.PsiAdapter;

public class GenerateToStringUtils {
    private static final Logger log = Logger.getInstance((String)"#org.jetbrains.generate.tostring.GenerateToStringUtils");

    private GenerateToStringUtils() {
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, FilterPattern pattern) {
        PsiField[] fields;
        if (log.isDebugEnabled()) {
            log.debug("Filtering fields using the pattern: " + pattern);
        }
        ArrayList<PsiField> availableFields = new ArrayList<PsiField>();
        for (PsiField field : fields = clazz.getFields()) {
            if (pattern.fieldMatches(field)) continue;
            availableFields.add(field);
        }
        PsiField[] psiFieldArray = availableFields.toArray(new PsiField[availableFields.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/generate/tostring/GenerateToStringUtils", "filterAvailableFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] filterAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern) {
        PsiMethod[] methods;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/generate/tostring/GenerateToStringUtils", "filterAvailableMethods"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Filtering methods using the pattern: " + pattern);
        }
        ArrayList<PsiMethod> availableMethods = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods = clazz.getMethods()) {
            String methodName;
            String fieldName;
            PsiType returnType;
            if (!PsiAdapter.isGetterMethod(method) || (returnType = method.getReturnType()) == null || PsiType.VOID.equals((Object)returnType) || !method.hasModifierProperty("public") || method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || clazz.findFieldByName(fieldName = PsiAdapter.getGetterFieldName(method), false) != null || "toString".equals(methodName = method.getName()) || "getClass".equals(methodName) || "hashCode".equals(methodName) || pattern.methodMatches(method)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding the method " + methodName + " as there is not a field for this getter");
            }
            availableMethods.add(method);
        }
        PsiMethod[] psiMethodArray = availableMethods.toArray(new PsiMethod[availableMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/generate/tostring/GenerateToStringUtils", "filterAvailableMethods"));
        }
        return psiMethodArray;
    }

    public static void handleException(Project project, Exception e) throws RuntimeException {
        log.info((Throwable)e);
        if (e instanceof GenerateCodeException) {
            Messages.showMessageDialog((Project)project, (String)("Velocity error generating code - see IDEA log for more details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Warning", (Icon)Messages.getWarningIcon());
        } else if (e instanceof PluginException) {
            Messages.showMessageDialog((Project)project, (String)("A PluginException was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Warning", (Icon)Messages.getWarningIcon());
        } else {
            if (e instanceof RuntimeException) {
                Messages.showMessageDialog((Project)project, (String)("An unrecoverable exception was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Error", (Icon)Messages.getErrorIcon());
                throw (RuntimeException)e;
            }
            Messages.showMessageDialog((Project)project, (String)("An unrecoverable exception was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Error", (Icon)Messages.getErrorIcon());
            throw new RuntimeException(e);
        }
    }

    public static PsiElementClassMember[] combineToClassMemberList(PsiField[] filteredFields, PsiMethod[] filteredMethods) {
        int i;
        PsiElementClassMember[] members = new PsiElementClassMember[filteredFields.length + filteredMethods.length];
        for (i = 0; i < filteredFields.length; ++i) {
            members[i] = new PsiFieldMember(filteredFields[i]);
        }
        for (i = 0; i < filteredMethods.length; ++i) {
            members[filteredFields.length + i] = new PsiMethodMember(filteredMethods[i]);
        }
        return members;
    }

    public static List<PsiMember> convertClassMembersToPsiMembers(List<PsiElementClassMember> classMemberList) {
        ArrayList<PsiMember> psiMemberList = new ArrayList<PsiMember>();
        for (PsiElementClassMember classMember : classMemberList) {
            psiMemberList.add((PsiMember)classMember.getElement());
        }
        return psiMemberList;
    }
}

