/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class ValueManager {
    private final AtomicInteger cacheStamp = new AtomicInteger();

    public void clearCaches() {
        this.cacheStamp.incrementAndGet();
    }

    @NotNull
    public Runnable getClearCachesTask() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ValueManager.this.clearCaches();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "getClearCachesTask"));
        }
        return runnable;
    }

    public final int getCacheStamp() {
        return this.cacheStamp.get();
    }
}

