/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueType;

public class PrimitiveValue
extends ValueBase {
    private final String valueString;

    public PrimitiveValue(@NotNull ValueType type, @NotNull String valueString) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/values/PrimitiveValue", "<init>"));
        }
        if (valueString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/values/PrimitiveValue", "<init>"));
        }
        super(type);
        this.valueString = valueString;
    }

    public PrimitiveValue(ValueType type, int value) {
        this(type, Integer.toString(value));
    }

    public PrimitiveValue(ValueType type, long value) {
        this(type, Long.toString(value));
    }

    @Override
    @Nullable
    public final String getValueString() {
        return this.valueString;
    }
}

