/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

public class SourceResolver {
    private final List<String> rawSources;
    final Url[] canonicalizedSources;
    private final ObjectIntHashMap<Url> canonicalizedSourcesMap;
    private TObjectIntHashMap<String> absoluteLocalPathToSourceIndex;
    private String[] sourceIndexToAbsoluteLocalPath;

    public SourceResolver(@NotNull List<String> sources, boolean trimFileScheme, @Nullable Url baseFileUrl) {
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "<init>"));
        }
        this.rawSources = sources;
        this.canonicalizedSources = new Url[sources.size()];
        this.canonicalizedSourcesMap = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.canonicalizedSources.length) : new ObjectIntHashMap(this.canonicalizedSources.length, Urls.getCaseInsensitiveUrlHashingStrategy());
        for (int i = 0; i < sources.size(); ++i) {
            Url url;
            this.canonicalizedSources[i] = url = this.canonicalizeUrl(sources.get(i), baseFileUrl, trimFileScheme, i);
            this.canonicalizedSourcesMap.put((Object)url, i);
        }
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "isAbsolute"));
        }
        return !path.isEmpty() && (path.charAt(0) == '/' || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':');
    }

    private Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, int sourceIndex) {
        VirtualFile file;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "canonicalizeUrl"));
        }
        if (trimFileScheme && url.startsWith("file://")) {
            return Urls.newLocalFileUrl(FileUtil.toCanonicalPath((String)VfsUtilCore.toIdeaUrl((String)url, (boolean)true).substring("file://".length()), (char)'/'));
        }
        if (baseUrl == null || url.contains("://") || url.startsWith("data:") || url.startsWith("blob:") || url.startsWith("javascript:")) {
            return Urls.parseEncoded(url);
        }
        String path = url;
        if (url.charAt(0) != '/') {
            String basePath = baseUrl.getPath();
            int lastSlashIndex = basePath.lastIndexOf(47);
            StringBuilder pathBuilder = new StringBuilder();
            if (lastSlashIndex == -1) {
                pathBuilder.append(basePath).append('/');
            } else {
                pathBuilder.append(basePath, 0, lastSlashIndex + 1);
            }
            path = pathBuilder.append(url).toString();
        }
        path = FileUtil.toCanonicalPath((String)path, (char)'/');
        if (baseUrl.getScheme() == null && baseUrl.isInLocalFileSystem()) {
            return Urls.newLocalFileUrl(path);
        }
        if (SourceResolver.isAbsolute(path) && (file = LocalFileFinder.findFile(path)) != null) {
            if (this.absoluteLocalPathToSourceIndex == null) {
                this.absoluteLocalPathToSourceIndex = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.rawSources.size()) : new ObjectIntHashMap(this.rawSources.size(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                this.sourceIndexToAbsoluteLocalPath = new String[this.rawSources.size()];
            }
            this.absoluteLocalPathToSourceIndex.put((Object)path, sourceIndex);
            this.sourceIndexToAbsoluteLocalPath[sourceIndex] = path;
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath != null && !canonicalPath.equals(path)) {
                this.absoluteLocalPathToSourceIndex.put((Object)canonicalPath, sourceIndex);
            }
        }
        return new UrlImpl(baseUrl.getScheme(), baseUrl.getAuthority(), path, null);
    }

    @Nullable
    public Url getSource(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "getSource"));
        }
        int index = entry.getSource();
        return index < 0 ? null : this.canonicalizedSources[index];
    }

    @Nullable
    public String getRawSource(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "getRawSource"));
        }
        int index = entry.getSource();
        return index < 0 ? null : this.rawSources.get(index);
    }

    @Nullable
    public String getLocalFilePath(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "getLocalFilePath"));
        }
        int index = entry.getSource();
        return index < 0 || this.sourceIndexToAbsoluteLocalPath == null ? null : this.sourceIndexToAbsoluteLocalPath[index];
    }

    @Nullable
    public MappingList findMappings(@NotNull SourceMap sourceMap, @NotNull Resolver resolver) {
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        int index = resolver.resolve(this.canonicalizedSourcesMap);
        return index < 0 ? null : sourceMap.sourceIndexToMappings[index];
    }

    @Nullable
    public MappingList findMappings(@NotNull List<Url> sourceUrls, @NotNull SourceMap sourceMap, @Nullable VirtualFile sourceFile) {
        MappingList mappings;
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        for (Url sourceUrl : sourceUrls) {
            int index = this.canonicalizedSourcesMap.get((Object)sourceUrl.trimParameters());
            if (index == -1) continue;
            return sourceMap.sourceIndexToMappings[index];
        }
        if (sourceFile != null && (mappings = this.findByFile(sourceMap, sourceFile)) != null) {
            return mappings;
        }
        return null;
    }

    @Nullable
    private MappingList findByFile(@NotNull SourceMap sourceMap, @NotNull VirtualFile sourceFile) {
        String sourceFileCanonicalPath;
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceResolver", "findByFile"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/sourcemap/SourceResolver", "findByFile"));
        }
        MappingList mappings = null;
        if (this.absoluteLocalPathToSourceIndex != null && sourceFile.isInLocalFileSystem() && (mappings = sourceMap.sourceIndexToMappings[this.absoluteLocalPathToSourceIndex.get((Object)sourceFile.getPath())]) == null && (sourceFileCanonicalPath = sourceFile.getCanonicalPath()) != null) {
            mappings = sourceMap.sourceIndexToMappings[this.absoluteLocalPathToSourceIndex.get((Object)sourceFileCanonicalPath)];
        }
        if (mappings == null) {
            int index = this.canonicalizedSourcesMap.get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters());
            if (index != -1) {
                return sourceMap.sourceIndexToMappings[index];
            }
            for (int i = 0; i < this.canonicalizedSources.length; ++i) {
                Url url = this.canonicalizedSources[i];
                if (Urls.equalsIgnoreParameters(url, sourceFile)) {
                    return sourceMap.sourceIndexToMappings[i];
                }
                VirtualFile canonicalFile = sourceFile.getCanonicalFile();
                if (canonicalFile == null || canonicalFile.equals(sourceFile) || !Urls.equalsIgnoreParameters(url, canonicalFile)) continue;
                return sourceMap.sourceIndexToMappings[i];
            }
        }
        return mappings;
    }

    public static interface Resolver {
        public int resolve(@NotNull ObjectIntHashMap<Url> var1);
    }
}

