/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.Url;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;

public class SourceMap {
    private final MappingList mappings;
    final MappingList[] sourceIndexToMappings;
    private final String outFile;
    private final SourceResolver sourceResolver;

    public SourceMap(@Nullable String outFile, @NotNull MappingList mappings, @NotNull MappingList[] sourceIndexToMappings, @NotNull SourceResolver sourceResolver) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/sourcemap/SourceMap", "<init>"));
        }
        if (sourceIndexToMappings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/sourcemap/SourceMap", "<init>"));
        }
        if (sourceResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/sourcemap/SourceMap", "<init>"));
        }
        this.outFile = outFile;
        this.mappings = mappings;
        this.sourceIndexToMappings = sourceIndexToMappings;
        this.sourceResolver = sourceResolver;
    }

    @NotNull
    public SourceResolver getSourceResolver() {
        SourceResolver sourceResolver = this.sourceResolver;
        if (sourceResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/SourceMap", "getSourceResolver"));
        }
        return sourceResolver;
    }

    @Nullable
    public String getOutFile() {
        return this.outFile;
    }

    public Url[] getSources() {
        return this.sourceResolver.canonicalizedSources;
    }

    public MappingList getMappings() {
        return this.mappings;
    }

    public boolean processMappingsInLine(@NotNull List<Url> sourceUrls, int sourceLine, @NotNull Processor<MappingEntry> mappingProcessor, @Nullable VirtualFile sourceFile, @Nullable NullableLazyValue<SourceResolver.Resolver> resolver) {
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/sourcemap/SourceMap", "processMappingsInLine"));
        }
        if (mappingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/sourcemap/SourceMap", "processMappingsInLine"));
        }
        MappingList mappings = this.sourceResolver.findMappings(sourceUrls, this, sourceFile);
        if (mappings == null) {
            SourceResolver.Resolver resolverValue;
            if (resolver != null && (resolverValue = (SourceResolver.Resolver)resolver.getValue()) != null) {
                mappings = this.sourceResolver.findMappings(this, resolverValue);
            }
            if (mappings == null) {
                return false;
            }
        }
        return mappings.processMappingsInLine(sourceLine, mappingProcessor);
    }

    @NotNull
    public MappingList getMappingsOrderedBySource(int source) {
        MappingList mappingList = this.sourceIndexToMappings[source];
        if (mappingList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/SourceMap", "getMappingsOrderedBySource"));
        }
        return mappingList;
    }
}

