/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.SourceInfo;

public abstract class StackFrameImplBase
extends XStackFrame {
    protected final SourceInfo sourceInfo;
    protected XDebuggerEvaluator evaluator;

    public StackFrameImplBase(@Nullable SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public final XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.createEvaluator();
        }
        return this.evaluator;
    }

    protected abstract XDebuggerEvaluator createEvaluator();

    public XSourcePosition getSourcePosition() {
        return this.sourceInfo;
    }

    protected boolean isInFileScope() {
        return false;
    }

    public final void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/frame/StackFrameImplBase", "customizePresentation"));
        }
        if (this.sourceInfo == null) {
            this.customizeInvalidFramePresentation(component);
            return;
        }
        String fileName = this.sourceInfo.getFile().getName();
        int line = this.sourceInfo.getLine() + 1;
        String functionName = this.sourceInfo.getFunctionName();
        if (functionName == null || functionName.isEmpty() && this.isInFileScope()) {
            component.append(fileName + ":" + line, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else {
            if (functionName.isEmpty()) {
                component.append("anonymous", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            component.append("(), " + fileName + ":" + line, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    protected void customizeInvalidFramePresentation(ColoredTextContainer component) {
        super.customizePresentation(component);
    }
}

