/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Vm;

public abstract class VmBase
implements Vm {
    private EvaluateContext evaluateContext;
    private final DebugEventListener debugListener;

    protected VmBase(@NotNull DebugEventListener debugListener) {
        if (debugListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/VmBase", "<init>"));
        }
        this.debugListener = debugListener;
    }

    @Override
    @NotNull
    public final synchronized EvaluateContext getEvaluateContext() {
        if (this.evaluateContext == null) {
            this.evaluateContext = this.computeEvaluateContext();
        }
        EvaluateContext evaluateContext = this.evaluateContext;
        if (evaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VmBase", "getEvaluateContext"));
        }
        return evaluateContext;
    }

    protected abstract EvaluateContext computeEvaluateContext();

    @Override
    @NotNull
    public final DebugEventListener getDebugListener() {
        DebugEventListener debugEventListener = this.debugListener;
        if (debugEventListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VmBase", "getDebugListener"));
        }
        return debugEventListener;
    }
}

