/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.ObsolescentAsyncResults;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextWrapper;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public final class Variables {
    public static final String SPECIAL_PROPERTY_PREFIX = "__";
    private static final Pattern UNNAMED_FUNCTION_PATTERN = Pattern.compile("^function[\\t ]*\\(");
    private static final Comparator<Variable> NATURAL_NAME_COMPARATOR = new Comparator<Variable>(){

        @Override
        public int compare(Variable o1, Variable o2) {
            return Variables.naturalCompare(o1.getName(), o2.getName());
        }
    };

    public static void processScopeVariables(@NotNull Scope scope, @NotNull XCompositeNode node, final @NotNull VariableContext context, final @Nullable ActionCallback compoundActionCallback) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        final boolean isLast = compoundActionCallback == null;
        AsyncResult result = ObsolescentAsyncResults.consume(scope.getVariables(), (Obsolescent)node, (PairConsumer)new PairConsumer<List<Variable>, XCompositeNode>(){

            public void consume(List<Variable> variables, XCompositeNode node) {
                ArrayList<Variable> properties = new ArrayList<Variable>(variables.size());
                SmartList functions = new SmartList();
                for (Variable variable : variables) {
                    if (!context.getMemberFilter().isMemberVisible(variable, false)) continue;
                    Value value = variable.getValue();
                    if (value != null && value.getType() == ValueType.FUNCTION && value.getValueString() != null && !UNNAMED_FUNCTION_PATTERN.matcher(value.getValueString()).lookingAt()) {
                        functions.add(variable);
                        continue;
                    }
                    properties.add(variable);
                }
                Variables.sort(properties);
                Variables.sort((List)functions);
                if (!properties.isEmpty()) {
                    node.addChildren(Variables.createVariablesList(properties, context), functions.isEmpty() && isLast);
                }
                if (!functions.isEmpty()) {
                    node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new VariablesGroup("Functions", (List<Variable>)functions, context)), isLast);
                } else if (isLast && properties.isEmpty()) {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                }
                if (!isLast) {
                    compoundActionCallback.setDone();
                }
            }
        });
        if (!isLast) {
            result.notifyWhenRejected(compoundActionCallback);
        }
    }

    @Nullable
    public static List<Variable> sortFilterAndAddValueList(@NotNull List<? extends Variable> variables, @NotNull XCompositeNode node, @NotNull VariableContext context, int maxChildrenToAdd, boolean defaultIsLast) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/Variables", "sortFilterAndAddValueList"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/Variables", "sortFilterAndAddValueList"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/Variables", "sortFilterAndAddValueList"));
        }
        List<Variable> list = Variables.filterAndSort(variables, context, true);
        if (list.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = Math.min(maxChildrenToAdd, list.size());
        boolean isLast = to == list.size();
        node.addChildren(Variables.createVariablesList(list, 0, to, context), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list.size() - to);
        return list;
    }

    public static List<Variable> filterAndSort(@NotNull List<? extends Variable> variables, @NotNull VariableContext context, boolean filterFunctions) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/Variables", "filterAndSort"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/Variables", "filterAndSort"));
        }
        if (variables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>(variables.size());
        for (Variable variable : variables) {
            if (!context.getMemberFilter().isMemberVisible(variable, filterFunctions)) continue;
            result.add(variable);
        }
        Variables.sort(result);
        return result;
    }

    private static void sort(List<Variable> result) {
        ContainerUtil.sort(result, NATURAL_NAME_COMPARATOR);
    }

    private static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit((char)ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit((char)ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit((char)string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit((char)string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (ch1 == ch2) continue;
            if (ch1 == '_') {
                return 1;
            }
            if (ch2 == '_') {
                return -1;
            }
            return ch1 - ch2;
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        return string1Length - string2Length;
    }

    public static XValueChildrenList createVariablesList(@NotNull List<Variable> variables, @NotNull VariableContext variableContext) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        return Variables.createVariablesList(variables, 0, variables.size(), variableContext);
    }

    public static XValueChildrenList createVariablesList(@NotNull List<Variable> variables, int from, int to, @NotNull VariableContext variableContext) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        XValueChildrenList list = new XValueChildrenList(to - from);
        NonWatchableVariableContext getterOrSetterContext = null;
        for (int i = from; i < to; ++i) {
            Variable variable = variables.get(i);
            list.add((XNamedValue)new VariableView(variable, variableContext));
            if (!(variable instanceof ObjectProperty)) continue;
            ObjectProperty property = (ObjectProperty)variable;
            if (property.getGetter() != null) {
                if (getterOrSetterContext == null) {
                    getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                }
                list.add((XNamedValue)new VariableView(new VariableImpl("get " + property.getName(), property.getGetter()), getterOrSetterContext));
            }
            if (property.getSetter() == null) continue;
            if (getterOrSetterContext == null) {
                getterOrSetterContext = new NonWatchableVariableContext(variableContext);
            }
            list.add((XNamedValue)new VariableView(new VariableImpl("set " + property.getName(), property.getSetter()), getterOrSetterContext));
        }
        return list;
    }

    private static class NonWatchableVariableContext
    extends VariableContextWrapper {
        public NonWatchableVariableContext(VariableContext variableContext) {
            super(variableContext, null);
        }

        @Override
        public boolean watchableAsEvaluationExpression() {
            return false;
        }
    }
}

