/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageHandler;
import org.jetbrains.rpc.MessageWriter;

public final class StandaloneVmHelper
extends MessageWriter {
    private volatile Channel channel;
    private final VmEx vm;

    public StandaloneVmHelper(VmEx vm) {
        this.vm = vm;
    }

    @Override
    public boolean write(@NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/StandaloneVmHelper", "write"));
        }
        return this.write((Object)content);
    }

    public boolean write(@NotNull Object content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/StandaloneVmHelper", "write"));
        }
        Channel currentChannel = this.channel;
        if (currentChannel == null || !currentChannel.isActive()) {
            return false;
        }
        currentChannel.writeAndFlush(content);
        return true;
    }

    public void setChannel(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/StandaloneVmHelper", "setChannel"));
        }
        this.channel = channel;
        channel.closeFuture().addListener((GenericFutureListener)new MyChannelFutureListener());
    }

    public boolean isAttached() {
        return this.channel != null;
    }

    public ActionCallback detach() {
        final Channel currentChannel = this.channel;
        if (currentChannel == null) {
            return new ActionCallback.Done();
        }
        this.vm.getCommandProcessor().cancelWaitingRequests();
        Request disconnectRequest = this.vm.createDisconnectRequest();
        if (disconnectRequest == null) {
            this.vm.getCommandProcessor().closed();
            this.channel = null;
            NettyUtil.closeAndReleaseFactory(currentChannel);
            return ActionCallback.DONE;
        }
        ActionCallback callback = this.vm.getCommandProcessor().send(disconnectRequest);
        this.vm.getCommandProcessor().closed();
        this.channel = null;
        final ActionCallback subCallback = new ActionCallback();
        callback.doWhenProcessed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StandaloneVmHelper.this.vm.getCommandProcessor().cancelWaitingRequests();
                    NettyUtil.closeAndReleaseFactory(currentChannel);
                }
                finally {
                    subCallback.setDone();
                }
            }
        });
        return subCallback;
    }

    private class MyChannelFutureListener
    implements ChannelFutureListener {
        private MyChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (StandaloneVmHelper.this.channel != null) {
                StandaloneVmHelper.this.vm.getCommandProcessor().closed();
                StandaloneVmHelper.this.vm.getDebugListener().disconnected();
            }
        }
    }

    public static interface VmEx
    extends Vm {
        public MessageHandler<?, ?, ?, ?> getCommandProcessor();

        @Nullable
        public Request createDisconnectRequest();
    }
}

