/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.AsyncValueLoaderManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Url;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManager;

public abstract class ScriptManagerBase<SCRIPT extends ScriptBase>
implements ScriptManager {
    private final AsyncValueLoaderManager<ScriptBase, String> scriptSourceLoader = new AsyncValueLoaderManager<ScriptBase, String>(ScriptBase.class){

        public void load(@NotNull ScriptBase script, @NotNull AsyncResult<String> result) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScriptManagerBase$1", "load"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ScriptManagerBase$1", "load"));
            }
            ScriptManagerBase.this.loadScriptSource(script, result);
        }
    };

    protected abstract void loadScriptSource(SCRIPT var1, AsyncResult<String> var2);

    @Override
    @NotNull
    public AsyncResult<String> getSource(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScriptManagerBase", "getSource"));
        }
        if (!this.containsScript(script)) {
            AsyncResult asyncResult = AsyncResult.rejected();
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptManagerBase", "getSource"));
            }
            return asyncResult;
        }
        AsyncResult asyncResult = this.scriptSourceLoader.get((Object)((ScriptBase)script));
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptManagerBase", "getSource"));
        }
        return asyncResult;
    }

    @Override
    public boolean hasSource(Script script) {
        return this.scriptSourceLoader.has((Object)((ScriptBase)script));
    }

    public void setSource(@NotNull SCRIPT script, @Nullable String source) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScriptManagerBase", "setSource"));
        }
        this.scriptSourceLoader.set(script, (Object)source);
    }

    @Override
    @Nullable
    public ActionCallback getScriptSourceMapLoadCallback(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScriptManagerBase", "getScriptSourceMapLoadCallback"));
        }
        return null;
    }

    @Override
    public Script forEachScript(@NotNull CommonProcessors.FindProcessor<Script> scriptProcessor) {
        if (scriptProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScriptManagerBase", "forEachScript"));
        }
        this.forEachScript((Processor<Script>)scriptProcessor);
        return (Script)scriptProcessor.getFoundValue();
    }

    public static boolean isSpecial(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScriptManagerBase", "isSpecial"));
        }
        return !url.isInLocalFileSystem() && (url.getScheme() == null || url.getScheme().equals("vm") || url.getAuthority() == null);
    }
}

