/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Url;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

public abstract class ScriptBase
extends UserDataHolderBase
implements Script {
    private volatile AsyncResult<String> source;
    private final Url url;
    protected final int line;
    protected final int column;
    protected final int endLine;
    protected final Script.Type type;
    private SourceMap sourceMap;

    protected ScriptBase(Script.Type type, @NotNull Url url, int line, int column, int endLine) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ScriptBase", "<init>"));
        }
        this.type = type;
        this.url = url;
        this.line = line;
        this.column = column;
        this.endLine = endLine;
    }

    @Override
    @NotNull
    public Url getUrl() {
        Url url = this.url;
        if (url == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScriptBase", "getUrl"));
        }
        return url;
    }

    @Override
    @Nullable
    public String getFunctionName() {
        return null;
    }

    @Override
    @Nullable
    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Override
    public void setSourceMap(@Nullable SourceMap sourceMap) {
        this.sourceMap = sourceMap;
    }

    @Override
    public Script.Type getType() {
        return this.type;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public String toString() {
        return "[url=" + this.getUrl() + ", lineRange=[" + this.getLine() + ';' + this.getEndLine() + "]]";
    }
}

