/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextWrapper;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Variables;

public class ScopeVariablesGroup
extends XValueGroup {
    private final Scope scope;
    private final VariableContext context;
    private final CallFrame callFrame;

    public ScopeVariablesGroup(@NotNull Scope scope, @NotNull VariableContext context, @Nullable CallFrame callFrame) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScopeVariablesGroup", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ScopeVariablesGroup", "<init>"));
        }
        super(ScopeVariablesGroup.createScopeNodeName(scope));
        this.scope = scope;
        this.context = callFrame == null || scope.getType() == Scope.Type.LIBRARY ? new ParentlessVariableContext(context, scope, scope.getType() == Scope.Type.GLOBAL) : new VariableContextWrapper(context, scope);
        this.callFrame = scope.getType() == Scope.Type.LOCAL ? callFrame : null;
    }

    public static void createAndAddScopeList(@NotNull XCompositeNode node, @NotNull List<Scope> scopes, @NotNull VariableContext context, @Nullable CallFrame callFrame) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScopeVariablesGroup", "createAndAddScopeList"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ScopeVariablesGroup", "createAndAddScopeList"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/ScopeVariablesGroup", "createAndAddScopeList"));
        }
        XValueChildrenList list = new XValueChildrenList(scopes.size());
        for (Scope scope : scopes) {
            list.addTopGroup((XValueGroup)new ScopeVariablesGroup(scope, context, callFrame));
        }
        node.addChildren(list, true);
    }

    private static String createScopeNodeName(@NotNull Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScopeVariablesGroup", "createScopeNodeName"));
        }
        switch (scope.getType()) {
            case GLOBAL: {
                return XDebuggerBundle.message((String)"scope.global", (Object[])new Object[0]);
            }
            case LOCAL: {
                return XDebuggerBundle.message((String)"scope.local", (Object[])new Object[0]);
            }
            case WITH: {
                return XDebuggerBundle.message((String)"scope.with", (Object[])new Object[0]);
            }
            case CLOSURE: {
                return XDebuggerBundle.message((String)"scope.closure", (Object[])new Object[0]);
            }
            case CATCH: {
                return XDebuggerBundle.message((String)"scope.catch", (Object[])new Object[0]);
            }
            case LIBRARY: {
                return XDebuggerBundle.message((String)"scope.library", (Object[])new Object[0]);
            }
            case INSTANCE: {
                return XDebuggerBundle.message((String)"scope.instance", (Object[])new Object[0]);
            }
            case CLASS: {
                return XDebuggerBundle.message((String)"scope.class", (Object[])new Object[0]);
            }
            case UNKNOWN: {
                return XDebuggerBundle.message((String)"scope.unknown", (Object[])new Object[0]);
            }
        }
        throw new IllegalArgumentException(scope.getType().name());
    }

    public boolean isAutoExpand() {
        return this.scope.getType() == Scope.Type.LOCAL || this.scope.getType() == Scope.Type.CATCH;
    }

    @Nullable
    public String getComment() {
        String className = this.scope.getDescription();
        return "Object".equals(className) ? null : className;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScopeVariablesGroup", "computeChildren"));
        }
        ActionCallback callback = this.callFrame == null ? null : new ActionCallback().doWhenDone(new Runnable(){

            @Override
            public void run() {
                if (node.isObsolete()) {
                    return;
                }
                ScopeVariablesGroup.this.callFrame.getReceiverVariable().doWhenDone((Consumer)new Consumer<Variable>(){

                    public void consume(Variable variable) {
                        if (!node.isObsolete()) {
                            node.addChildren(variable == null ? XValueChildrenList.EMPTY : XValueChildrenList.singleton((String)"this", (XValue)new VariableView(variable, ScopeVariablesGroup.this.context)), true);
                        }
                    }
                }).doWhenRejected((Consumer)new Consumer<String>(){

                    public void consume(@Nullable String error) {
                        if (!node.isObsolete()) {
                            node.addChildren(XValueChildrenList.EMPTY, true);
                        }
                    }
                });
            }
        });
        Variables.processScopeVariables(this.scope, node, this.context, callback);
    }

    private static final class ParentlessVariableContext
    extends VariableContextWrapper {
        private final boolean watchableAsEvaluationExpression;

        public ParentlessVariableContext(@NotNull VariableContext parentContext, @NotNull Scope scope, boolean watchableAsEvaluationExpression) {
            if (parentContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScopeVariablesGroup$ParentlessVariableContext", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/ScopeVariablesGroup$ParentlessVariableContext", "<init>"));
            }
            super(parentContext, scope);
            this.watchableAsEvaluationExpression = watchableAsEvaluationExpression;
        }

        @Override
        public boolean watchableAsEvaluationExpression() {
            return this.watchableAsEvaluationExpression;
        }

        @Override
        @Nullable
        public VariableContext getParent() {
            return null;
        }
    }
}

