/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Scope;

public abstract class ScopeBase
implements Scope {
    private final Scope.Type type;
    private final String description;

    protected ScopeBase(@NotNull Scope.Type type, @Nullable String description) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/ScopeBase", "<init>"));
        }
        this.type = type;
        this.description = description;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Scope.Type getType() {
        Scope.Type type = this.type;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ScopeBase", "getType"));
        }
        return type;
    }

    @Override
    public final boolean isGlobal() {
        return this.type == Scope.Type.GLOBAL || this.type == Scope.Type.LIBRARY;
    }
}

