/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueGroupFactory;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Variables;
import org.jetbrains.debugger.values.ArrayValue;

final class LazyVariablesGroup
extends XValueGroup {
    public static final ValueGroupFactory<ArrayValue> GROUP_FACTORY = new ValueGroupFactory<ArrayValue>(){

        @Override
        public XValueGroup create(@NotNull ArrayValue value, int start, int end, @NotNull VariableContext context) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/LazyVariablesGroup$1", "create"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/LazyVariablesGroup$1", "create"));
            }
            return new LazyVariablesGroup(value, start, end, context);
        }
    };
    private final ArrayValue value;
    private final int start;
    private final int end;
    private final VariableContext context;

    public LazyVariablesGroup(@NotNull ArrayValue value, int start, int end, @NotNull VariableContext context) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/LazyVariablesGroup", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/LazyVariablesGroup", "<init>"));
        }
        super(String.format("[%,d \u2026 %,d]", start, end));
        this.value = value;
        this.start = start;
        this.end = end;
        this.context = context;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/LazyVariablesGroup", "computeChildren"));
        }
        node.setAlreadySorted(true);
        this.value.getVariables(this.start, this.end, 100, new VariableView.ObsolescentIndexedVariablesConsumer(node){

            @Override
            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroup.addGroups(LazyVariablesGroup.this.value, GROUP_FACTORY, groupList, LazyVariablesGroup.this.start, LazyVariablesGroup.this.end, 100, LazyVariablesGroup.this.context);
                    this.node.addChildren(groupList, true);
                } else {
                    LazyVariablesGroup.addRanges(LazyVariablesGroup.this.value, ranges, this.node, LazyVariablesGroup.this.context, true);
                }
            }

            @Override
            public void consumeVariables(@NotNull List<Variable> variables) {
                if (variables == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/LazyVariablesGroup$2", "consumeVariables"));
                }
                this.node.addChildren(Variables.createVariablesList(variables, LazyVariablesGroup.this.context), true);
            }
        });
    }

    public static void addRanges(@NotNull ArrayValue value, int[] ranges, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/LazyVariablesGroup", "addRanges"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/LazyVariablesGroup", "addRanges"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/LazyVariablesGroup", "addRanges"));
        }
        XValueChildrenList groupList = new XValueChildrenList(ranges.length / 2);
        int n = ranges.length;
        for (int i = 0; i < n; i += 2) {
            groupList.addTopGroup((XValueGroup)new LazyVariablesGroup(value, ranges[i], ranges[i + 1], context));
        }
        node.addChildren(groupList, isLast);
    }

    public static <T> void addGroups(@NotNull T data, @NotNull ValueGroupFactory<T> groupFactory, @NotNull XValueChildrenList groupList, int from, int limit, int bucketSize, @NotNull VariableContext context) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/LazyVariablesGroup", "addGroups"));
        }
        if (groupFactory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/LazyVariablesGroup", "addGroups"));
        }
        if (groupList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/LazyVariablesGroup", "addGroups"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/debugger/LazyVariablesGroup", "addGroups"));
        }
        int to = Math.min(bucketSize, limit);
        boolean done = false;
        do {
            int groupFrom = from;
            int groupTo = to;
            if ((to = (from += bucketSize) + Math.min(bucketSize, limit - from)) - from == 1) {
                ++groupTo;
                done = true;
            }
            groupList.addTopGroup(groupFactory.create(data, groupFrom, groupTo, context));
        } while (from < limit && !done);
    }
}

