/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.PairConsumer;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.ObsolescentAsyncResults;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.FunctionValue;

class FunctionScopesValueGroup
extends XValueGroup {
    private final FunctionValue value;
    private final VariableContext variableContext;

    public FunctionScopesValueGroup(@NotNull FunctionValue value, @NotNull VariableContext variableContext) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/FunctionScopesValueGroup", "<init>"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/FunctionScopesValueGroup", "<init>"));
        }
        super("Function scopes");
        this.value = value;
        this.variableContext = variableContext;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/FunctionScopesValueGroup", "computeChildren"));
        }
        node.setAlreadySorted(true);
        ObsolescentAsyncResults.consume(this.value.resolve(), (Obsolescent)node, (PairConsumer)new PairConsumer<FunctionValue, XCompositeNode>(){

            public void consume(FunctionValue value, XCompositeNode node) {
                Scope[] scopes = value.getScopes();
                if (scopes == null || scopes.length == 0) {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                } else {
                    ScopeVariablesGroup.createAndAddScopeList(node, Arrays.asList(scopes), FunctionScopesValueGroup.this.variableContext, null);
                }
            }
        });
    }
}

