/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.AsyncValueLoaderManager;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeBase;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueManager;

public abstract class DeclarativeScope<VALUE_LOADER extends ValueManager>
extends ScopeBase {
    private static final AsyncValueLoaderManager<DeclarativeScope, List<Variable>> VARIABLES_LOADER = new AsyncValueLoaderManager<DeclarativeScope, List<Variable>>(DeclarativeScope.class){

        public boolean isUpToDate(@NotNull DeclarativeScope host, @NotNull List<Variable> data) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DeclarativeScope$1", "isUpToDate"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DeclarativeScope$1", "isUpToDate"));
            }
            return ((ValueManager)host.valueManager).getCacheStamp() == host.cacheStamp;
        }

        public void load(@NotNull DeclarativeScope host, @NotNull AsyncResult<List<Variable>> result) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DeclarativeScope$1", "load"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DeclarativeScope$1", "load"));
            }
            host.loadVariables(result);
        }
    };
    private volatile AsyncResult<List<? extends Variable>> variables;
    private volatile int cacheStamp;
    protected final VALUE_LOADER valueManager;

    protected DeclarativeScope(@NotNull Scope.Type type, @Nullable String description, @NotNull VALUE_LOADER valueManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DeclarativeScope", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/DeclarativeScope", "<init>"));
        }
        super(type, description);
        this.cacheStamp = -1;
        this.valueManager = valueManager;
    }

    protected abstract void loadVariables(@NotNull AsyncResult<List<? extends Variable>> var1);

    protected final void updateCacheStamp() {
        this.cacheStamp = ((ValueManager)this.valueManager).getCacheStamp();
    }

    protected final void loadScopeObjectProperties(@NotNull ObjectValue value, final @NotNull AsyncResult<List<? extends Variable>> result) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DeclarativeScope", "loadScopeObjectProperties"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DeclarativeScope", "loadScopeObjectProperties"));
        }
        value.getProperties().doWhenDone((Consumer)new Consumer<List<Variable>>(){

            public void consume(List<Variable> variables) {
                DeclarativeScope.this.updateCacheStamp();
                result.setDone(variables);
            }
        }).notifyWhenRejected(result);
    }

    @Override
    @NotNull
    public final AsyncResult<List<Variable>> getVariables() {
        AsyncResult asyncResult = VARIABLES_LOADER.get((Object)this);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DeclarativeScope", "getVariables"));
        }
        return asyncResult;
    }

    @Override
    @NotNull
    public ActionCallback clearCaches() {
        this.cacheStamp = -1;
        VARIABLES_LOADER.reset((Object)this);
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DeclarativeScope", "clearCaches"));
        }
        return actionCallback;
    }
}

