/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueNode;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

public interface DebuggerViewSupport
extends MemberFilter {
    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script var1, @NotNull CallFrame var2);

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String var1, @NotNull String var2, int var3, int var4);

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String var1, @NotNull Script var2, int var3, int var4);

    public Vm getVm();

    @NotNull
    public String propertyNamesToString(@NotNull List<String> var1, boolean var2);

    public void computeObjectPresentation(@NotNull ObjectValue var1, @NotNull Variable var2, @NotNull VariableContext var3, @NotNull XValueNode var4, @NotNull Icon var5);

    public void computeArrayPresentation(@NotNull Value var1, @NotNull Variable var2, @NotNull VariableContext var3, @NotNull XValueNode var4, @NotNull Icon var5);

    @NotNull
    public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView var1);

    public boolean canNavigateToSource(@NotNull Variable var1, @NotNull VariableContext var2);

    public void computeSourcePosition(@NotNull Variable var1, @NotNull VariableContext var2, @NotNull XNavigatable var3);

    public static class SimpleDebuggerViewSupport
    implements DebuggerViewSupport {
        public static final DebuggerViewSupport INSTANCE = new SimpleDebuggerViewSupport();

        @Override
        @Nullable
        public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
            if (frame == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "getSourceInfo"));
            }
            return null;
        }

        @Override
        @Nullable
        public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
            if (scriptUrl == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "getSourceInfo"));
            }
            return null;
        }

        @Override
        @Nullable
        public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "getSourceInfo"));
            }
            return null;
        }

        @Override
        public Vm getVm() {
            return null;
        }

        @Override
        @NotNull
        public String propertyNamesToString(@NotNull List<String> list, boolean quotedAware) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "propertyNamesToString"));
            }
            String string = ValueModifierUtil.propertyNamesToString(list, quotedAware);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "propertyNamesToString"));
            }
            return string;
        }

        @Override
        public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeObjectPresentation"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeObjectPresentation"));
            }
            VariableView.setObjectPresentation(value, icon, node);
        }

        @Override
        public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeArrayPresentation"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeArrayPresentation"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeArrayPresentation"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeArrayPresentation"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeArrayPresentation"));
            }
            VariableView.setArrayPresentation(value, context, icon, node);
        }

        @Override
        @NotNull
        public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frameView) {
            if (frameView == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "createFrameEvaluator"));
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "canNavigateToSource"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "canNavigateToSource"));
            }
            return false;
        }

        @Override
        public void computeSourcePosition(@NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeSourcePosition"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeSourcePosition"));
            }
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "computeSourcePosition"));
            }
        }

        @Override
        public boolean isMemberVisible(@NotNull Variable variable, boolean filterFunctions) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "isMemberVisible"));
            }
            return true;
        }

        @Override
        @NotNull
        public String normalizeMemberName(@NotNull Variable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "normalizeMemberName"));
            }
            String string = variable.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebuggerViewSupport$SimpleDebuggerViewSupport", "normalizeMemberName"));
            }
            return string;
        }
    }
}

