/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;

class SimplifyQuantifierAction
implements IntentionAction {
    private final RegExpQuantifier myQuantifier;
    private final String myReplacement;

    public SimplifyQuantifierAction(RegExpQuantifier quantifier, String s) {
        this.myQuantifier = quantifier;
        this.myReplacement = s;
    }

    @NotNull
    public String getText() {
        String string = this.myReplacement == null ? "Simplify" : "Replace with '" + this.myReplacement + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Simplify Quantifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "getFamilyName"));
        }
        return "Simplify Quantifier";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "isAvailable"));
        }
        return this.myQuantifier.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/validation/SimplifyQuantifierAction", "invoke"));
        }
        if (this.myReplacement == null) {
            this.myQuantifier.delete();
        } else {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
            PsiFile f = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)("a" + this.myReplacement + this.myQuantifier.getType().getToken()));
            RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
            assert (pattern != null);
            RegExpClosure closure = (RegExpClosure)pattern.getBranches()[0].getAtoms()[0];
            this.myQuantifier.replace(closure.getQuantifier());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

