/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupSurrounder
implements Surrounder {
    private final String myTitle;
    private final String myGroupStart;

    public GroupSurrounder(String title, String groupStart) {
        this.myTitle = title;
        this.myGroupStart = groupStart;
    }

    public String getTemplateDescription() {
        return this.myTitle;
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "isApplicable"));
        }
        return elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/intellij/lang/regexp/surroundWith/GroupSurrounder", "surroundElements"));
        }
        assert (elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent());
        PsiElement e = elements[0];
        ASTNode node = e.getNode();
        assert (node != null);
        ASTNode parent = node.getTreeParent();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            if (element instanceof RegExpElementImpl) {
                s.append(((RegExpElementImpl)element).getUnescapedText());
            } else {
                s.append(element.getText());
            }
            if (i <= 0) continue;
            ASTNode child = element.getNode();
            assert (child != null);
            parent.removeChild(child);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        PsiFile f = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.makeReplacement(s));
        RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
        assert (pattern != null);
        RegExpAtom element = pattern.getBranches()[0].getAtoms()[0];
        if (GroupSurrounder.isInsideStringLiteral(e)) {
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
            TextRange tr = e.getTextRange();
            doc.replaceString(tr.getStartOffset(), tr.getEndOffset(), (CharSequence)StringUtil.escapeStringCharacters((String)element.getText()));
            return TextRange.from((int)e.getTextRange().getEndOffset(), (int)0);
        }
        PsiElement n = e.replace((PsiElement)element);
        return TextRange.from((int)n.getTextRange().getEndOffset(), (int)0);
    }

    private static boolean isInsideStringLiteral(PsiElement context) {
        while (context != null) {
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return true;
            }
            context = context.getContext();
        }
        return false;
    }

    protected String makeReplacement(StringBuilder s) {
        return this.myGroupStart + s + ")";
    }
}

