/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpModifierProvider;

public class CheckRegExpForm {
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private Pair<PsiFile, Ref<Balloon>> myParams;
    private EditorTextField mySampleText;
    private EditorTextField myRegExp;
    private JPanel myRootPanel;
    private Ref<Balloon> myRef;
    private Project myProject;

    public CheckRegExpForm(Pair<PsiFile, Ref<Balloon>> params) {
        this.myParams = params;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        PsiFile file = (PsiFile)this.myParams.first;
        this.myProject = file.getProject();
        this.myRef = (Ref)this.myParams.second;
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        this.myRegExp = new EditorTextField(document, this.myProject, (FileType)RegExpLanguage.INSTANCE.getAssociatedFileType());
        String sampleText = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_EDITED_REGEXP, "Sample Text");
        this.mySampleText = new EditorTextField(sampleText, this.myProject, (FileType)PlainTextFileType.INSTANCE);
        this.mySampleText.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 4), new LineBorder((Color)(UIUtil.isUnderDarcula() ? Gray._100 : UIUtil.getBorderColor()))));
        this.mySampleText.setOneLineMode(false);
        this.mySampleText.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckRegExpForm.this.myRootPanel.revalidate();
                        Balloon balloon = (Balloon)CheckRegExpForm.this.myRef.get();
                        if (balloon != null) {
                            balloon.revalidate();
                        }
                    }
                });
            }
        });
        this.myRootPanel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        IdeFocusManager.findInstance().requestFocus((Component)CheckRegExpForm.this.myRegExp.getFocusTarget(), true);
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)((Object)CheckRegExpForm.this.mySampleText), (Disposable)CheckRegExpForm.this.myRef.get());
                AnAction escaper = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        ((Balloon)CheckRegExpForm.this.myRef.get()).hide();
                    }
                };
                escaper.registerCustomShortcutSet(CommonShortcuts.ESCAPE, CheckRegExpForm.this.myRegExp.getFocusTarget(), (Disposable)CheckRegExpForm.this.myRef.get());
                escaper.registerCustomShortcutSet(CommonShortcuts.ESCAPE, CheckRegExpForm.this.mySampleText.getFocusTarget(), (Disposable)CheckRegExpForm.this.myRef.get());
                ((Balloon)CheckRegExpForm.this.myRef.get()).addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        PropertiesComponent.getInstance((Project)CheckRegExpForm.this.myProject).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
                    }
                });
                final Alarm updater = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)CheckRegExpForm.this.myRef.get());
                DocumentAdapter documentListener = new DocumentAdapter(){

                    public void documentChanged(DocumentEvent e) {
                        updater.cancelAllRequests();
                        if (!updater.isDisposed()) {
                            updater.addRequest(new Runnable(){

                                @Override
                                public void run() {
                                    CheckRegExpForm.this.updateBalloon();
                                }
                            }, 200);
                        }
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener((DocumentListener)documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener((DocumentListener)documentListener);
                CheckRegExpForm.this.updateBalloon();
                CheckRegExpForm.this.mySampleText.selectAll();
            }
        };
    }

    public JPanel getRootPanel() {
        return this.myRootPanel;
    }

    private void updateBalloon() {
        boolean correct = false;
        try {
            PsiElement regexpInHost;
            PsiFile host;
            PsiFile file = (PsiFile)this.myParams.first;
            int offset = -1;
            try {
                String name = file.getName();
                offset = Integer.parseInt(name.substring(name.lastIndexOf(58) + 1, name.lastIndexOf(41)));
            }
            catch (Exception ignore) {
                // empty catch block
            }
            int flags = 0;
            if (offset != -1 && (host = FileContextUtil.getContextFile((PsiElement)file)) != null && (regexpInHost = host.findElementAt(offset)) != null) {
                for (RegExpModifierProvider provider : (RegExpModifierProvider[])RegExpModifierProvider.EP.getExtensions()) {
                    int modifiers = provider.getFlags(regexpInHost, file);
                    if (modifiers <= 0) continue;
                    flags = modifiers;
                    break;
                }
            }
            correct = Pattern.compile(this.myRegExp.getText(), flags).matcher(this.mySampleText.getText()).matches();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.mySampleText.setBackground((Color)(correct ? new JBColor(new Color(231, 250, 219), new Color(68, 85, 66)) : new JBColor(new Color(255, 177, 160), new Color(110, 43, 40))));
        BalloonImpl balloon = (BalloonImpl)this.myRef.get();
        if (balloon != null && balloon.isDisposed()) {
            balloon.revalidate();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        this.createUIComponents();
        JPanel jPanel = this.myRootPanel;
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "North");
        EditorTextField editorTextField = this.myRegExp;
        jPanel4.add((Component)((Object)editorTextField), "Center");
        JLabel jLabel = new JLabel();
        jLabel.setText("RegExp:");
        jLabel.setAlignmentX(1.0f);
        jLabel.setPreferredSize(new Dimension(55, 16));
        jPanel4.add((Component)jLabel, "West");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel5, "Center");
        EditorTextField editorTextField2 = this.mySampleText;
        jPanel5.add((Component)((Object)editorTextField2), "Center");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Sample:");
        jLabel2.setAlignmentY(0.0f);
        jLabel2.setAlignmentX(1.0f);
        jLabel2.setPreferredSize(new Dimension(55, 16));
        jPanel5.add((Component)jLabel2, "West");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, "South");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Red means Sample does not match RegExp");
        jBLabel.setAlignmentX(0.5f);
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

