/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PsiActionSupportFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

final class ImageEditorUI
extends JPanel
implements DataProvider {
    @NonNls
    private static final String IMAGE_PANEL = "image";
    @NonNls
    private static final String ERROR_PANEL = "error";
    private final ImageEditor editor;
    private final DeleteProvider deleteProvider;
    private final CopyPasteSupport copyPasteSupport;
    private final ImageZoomModel zoomModel = new ImageZoomModelImpl();
    private final ImageWheelAdapter wheelAdapter = new ImageWheelAdapter();
    private final ChangeListener changeListener = new DocumentChangeListener();
    private final ImageComponent imageComponent = new ImageComponent();
    private final JPanel contentPanel;
    private final JLabel infoLabel;

    ImageEditorUI(ImageEditor editor, EditorOptions editorOptions) {
        this.editor = editor;
        PsiActionSupportFactory factory = PsiActionSupportFactory.getInstance();
        this.copyPasteSupport = factory != null ? factory.createPsiBasedCopyPasteSupport(editor.getProject(), (JComponent)this, new PsiActionSupportFactory.PsiElementSelector(){

            public PsiElement[] getSelectedElements() {
                PsiElement[] data = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData((DataProvider)ImageEditorUI.this);
                return data == null ? PsiElement.EMPTY_ARRAY : data;
            }
        }) : null;
        this.deleteProvider = factory == null ? null : factory.createPsiBasedDeleteProvider();
        ImageDocument document = this.imageComponent.getDocument();
        document.addChangeListener(this.changeListener);
        TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        this.imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
        this.imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
        this.imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
        this.imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
        this.imageComponent.setGridLineSpan(gridOptions.getLineSpan());
        this.imageComponent.setGridLineColor(gridOptions.getLineColor());
        ImageContainerPane view = new ImageContainerPane(this.imageComponent);
        view.addMouseListener((MouseListener)((Object)new EditorMouseAdapter()));
        view.addMouseListener(new FocusRequester());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)view));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.addMouseWheelListener(this.wheelAdapter);
        this.setLayout(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorToolbar");
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Editor", actionGroup, true);
        actionToolbar.setTargetComponent((JComponent)this);
        JComponent toolbarPanel = actionToolbar.getComponent();
        toolbarPanel.addMouseListener(new FocusRequester());
        JLabel errorLabel = new JLabel(ImagesBundle.message("error.broken.image.file.format", new Object[0]), Messages.getErrorIcon(), 0);
        JPanel errorPanel = new JPanel(new BorderLayout());
        errorPanel.add((Component)errorLabel, "Center");
        this.contentPanel = new JPanel(new CardLayout());
        this.contentPanel.add((Component)scrollPane, IMAGE_PANEL);
        this.contentPanel.add((Component)errorPanel, ERROR_PANEL);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)toolbarPanel, "West");
        this.infoLabel = new JLabel((String)null, 4);
        topPanel.add((Component)this.infoLabel, "East");
        this.add((Component)topPanel, "North");
        this.add((Component)this.contentPanel, "Center");
        this.updateInfo();
    }

    private void updateInfo() {
        ImageDocument document = this.imageComponent.getDocument();
        BufferedImage image = document.getValue();
        if (image != null) {
            ColorModel colorModel = image.getColorModel();
            String format = document.getFormat();
            format = format == null ? ImagesBundle.message("unknown.format", new Object[0]) : format.toUpperCase();
            VirtualFile file = this.editor.getFile();
            this.infoLabel.setText(ImagesBundle.message("image.info", image.getWidth(), image.getHeight(), format, colorModel.getPixelSize(), file != null ? StringUtil.formatFileSize((long)file.getLength()) : ""));
        } else {
            this.infoLabel.setText(null);
        }
    }

    JComponent getContentComponent() {
        return this.contentPanel;
    }

    ImageComponent getImageComponent() {
        return this.imageComponent;
    }

    void dispose() {
        this.imageComponent.removeMouseWheelListener(this.wheelAdapter);
        this.imageComponent.getDocument().removeChangeListener(this.changeListener);
        this.removeAll();
    }

    ImageZoomModel getZoomModel() {
        return this.zoomModel;
    }

    @Nullable
    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.editor.getProject();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.editor.getFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return new VirtualFile[]{this.editor.getFile()};
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return this.getData(CommonDataKeys.PSI_ELEMENT.getName());
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            VirtualFile file = this.editor.getFile();
            return file != null && file.isValid() ? PsiManager.getInstance((Project)this.editor.getProject()).findFile(file) : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return new PsiElement[]{(PsiElement)this.getData(CommonDataKeys.PSI_ELEMENT.getName())};
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this.copyPasteSupport.getCopyProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId) && this.copyPasteSupport != null) {
            return this.copyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.deleteProvider;
        }
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this.editor;
        }
        return null;
    }

    private static final class EditorMouseAdapter
    extends PopupHandler {
        private EditorMouseAdapter() {
        }

        public void invokePopup(Component comp, int x, int y) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.EditorPopupMenu");
            ActionPopupMenu menu = actionManager.createActionPopupMenu("Images.Editor", actionGroup);
            JPopupMenu popupMenu = menu.getComponent();
            popupMenu.pack();
            popupMenu.show(comp, x, y);
        }
    }

    private class FocusRequester
    extends MouseAdapter {
        private FocusRequester() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ImageEditorUI.this.requestFocus();
        }
    }

    private class DocumentChangeListener
    implements ChangeListener {
        private DocumentChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ImageDocument document = ImageEditorUI.this.imageComponent.getDocument();
            BufferedImage value = document.getValue();
            CardLayout layout = (CardLayout)ImageEditorUI.this.contentPanel.getLayout();
            layout.show(ImageEditorUI.this.contentPanel, value != null ? ImageEditorUI.IMAGE_PANEL : ImageEditorUI.ERROR_PANEL);
            ImageEditorUI.this.updateInfo();
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
        }
    }

    private class ImageZoomModelImpl
    implements ImageZoomModel {
        private boolean myZoomLevelChanged = false;

        private ImageZoomModelImpl() {
        }

        @Override
        public double getZoomFactor() {
            Dimension size = ImageEditorUI.this.imageComponent.getCanvasSize();
            BufferedImage image = ImageEditorUI.this.imageComponent.getDocument().getValue();
            return image != null ? size.getWidth() / (double)image.getWidth() : 0.0;
        }

        @Override
        public void setZoomFactor(double zoomFactor) {
            Dimension size = ImageEditorUI.this.imageComponent.getCanvasSize();
            BufferedImage image = ImageEditorUI.this.imageComponent.getDocument().getValue();
            if (image != null) {
                size.setSize((double)image.getWidth() * zoomFactor, (double)image.getHeight() * zoomFactor);
                ImageEditorUI.this.imageComponent.setCanvasSize(size);
            }
            ImageEditorUI.this.revalidate();
            ImageEditorUI.this.repaint();
            this.myZoomLevelChanged = false;
        }

        private double getMinimumZoomFactor() {
            BufferedImage image = ImageEditorUI.this.imageComponent.getDocument().getValue();
            return image != null ? 1.0 / (double)image.getWidth() : 0.0;
        }

        @Override
        public void zoomOut() {
            double factor = this.getZoomFactor();
            if (factor > 1.0) {
                this.setZoomFactor(factor / 2.0);
            } else {
                double minFactor = this.getMinimumZoomFactor();
                double stepSize = (1.0 - minFactor) / 8.0;
                int step = (int)Math.ceil((1.0 - factor) / stepSize);
                this.setZoomFactor(1.0 - stepSize * (double)(step + 1));
            }
            this.myZoomLevelChanged = true;
        }

        @Override
        public void zoomIn() {
            double factor = this.getZoomFactor();
            if (factor >= 1.0) {
                this.setZoomFactor(factor * 2.0);
            } else {
                double minFactor = this.getMinimumZoomFactor();
                double stepSize = (1.0 - minFactor) / 8.0;
                double step = (1.0 - factor) / stepSize;
                this.setZoomFactor(1.0 - stepSize * (step - 1.0));
            }
            this.myZoomLevelChanged = true;
        }

        @Override
        public boolean canZoomOut() {
            double minFactor;
            double stepSize;
            double factor = this.getZoomFactor();
            double step = Math.ceil((1.0 - factor) / (stepSize = (1.0 - (minFactor = this.getMinimumZoomFactor())) / 8.0));
            return step < 8.0;
        }

        @Override
        public boolean canZoomIn() {
            double zoomFactor = this.getZoomFactor();
            return zoomFactor < 32.0;
        }

        @Override
        public boolean isZoomLevelChanged() {
            return this.myZoomLevelChanged;
        }
    }

    private final class ImageWheelAdapter
    implements MouseWheelListener {
        private ImageWheelAdapter() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            ZoomOptions zoomOptions = editorOptions.getZoomOptions();
            if (zoomOptions.isWheelZooming() && e.isControlDown()) {
                if (e.getWheelRotation() < 0) {
                    ImageEditorUI.this.zoomModel.zoomOut();
                } else {
                    ImageEditorUI.this.zoomModel.zoomIn();
                }
                e.consume();
            }
        }
    }

    private static final class ImageContainerPane
    extends JBLayeredPane {
        private final ImageComponent imageComponent;

        public ImageContainerPane(ImageComponent imageComponent) {
            this.imageComponent = imageComponent;
            this.add(imageComponent);
        }

        private void centerComponents() {
            Rectangle bounds = this.getBounds();
            Point point = this.imageComponent.getLocation();
            point.x = (bounds.width - this.imageComponent.getWidth()) / 2;
            point.y = (bounds.height - this.imageComponent.getHeight()) / 2;
            this.imageComponent.setLocation(point);
        }

        public void invalidate() {
            this.centerComponents();
            super.invalidate();
        }

        public Dimension getPreferredSize() {
            return this.imageComponent.getSize();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (UIUtil.isUnderDarcula()) {
                g.setColor(UIUtil.getControlColor().brighter());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

