/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.jetbrains.annotations.NotNull;

public final class ImageEditorManagerImpl {
    private ImageEditorManagerImpl() {
    }

    @NotNull
    public static ImageEditor createImageEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditor"));
        }
        ImageEditorImpl imageEditorImpl = new ImageEditorImpl(project, file);
        if (imageEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "createImageEditor"));
        }
        return imageEditorImpl;
    }

    public static void releaseImageEditor(@NotNull ImageEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/images/editor/impl/ImageEditorManagerImpl", "releaseImageEditor"));
        }
        if (!editor.isDisposed()) {
            editor.dispose();
        }
    }
}

