/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.parenthesis;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.parenthesis.AddClarifyingParenthesesPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddClarifyingParenthesesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AddClarifyingParenthesesPredicate addClarifyingParenthesesPredicate = new AddClarifyingParenthesesPredicate();
        if (addClarifyingParenthesesPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/parenthesis/AddClarifyingParenthesesIntention", "getElementPredicate"));
        }
        return addClarifyingParenthesesPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiConditionalExpression conditionalExpression;
        PsiExpression condition;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/parenthesis/AddClarifyingParenthesesIntention", "processIntention"));
        }
        PsiExpression expression = AddClarifyingParenthesesIntention.getTopLevelExpression(element);
        if (expression == null) {
            return;
        }
        StringBuilder newExpression = AddClarifyingParenthesesIntention.createReplacementText(expression, new StringBuilder());
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiConditionalExpression && expression == (condition = (conditionalExpression = (PsiConditionalExpression)parent).getCondition())) {
            PsiReplacementUtil.replaceExpression(expression, '(' + newExpression.toString() + ')');
            return;
        }
        PsiReplacementUtil.replaceExpression(expression, newExpression.toString());
    }

    @Nullable
    private static PsiExpression getTopLevelExpression(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        PsiExpression result = (PsiExpression)element;
        PsiElement parent = result.getParent();
        while (parent instanceof PsiPolyadicExpression || parent instanceof PsiParenthesizedExpression) {
            result = (PsiExpression)parent;
            parent = result.getParent();
        }
        return result;
    }

    private static StringBuilder createReplacementText(@Nullable PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parent;
                IElementType parentOperationSign = parentPolyadicExpression.getOperationTokenType();
                boolean parentheses = !tokenType.equals(parentOperationSign);
                AddClarifyingParenthesesIntention.appendText(polyadicExpression, parentheses, out);
            } else {
                boolean parentheses = parent instanceof PsiConditionalExpression || parent instanceof PsiInstanceOfExpression;
                AddClarifyingParenthesesIntention.appendText(polyadicExpression, parentheses, out);
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression unwrappedExpression = parenthesizedExpression.getExpression();
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiParenthesizedExpression)) {
                out.append('(');
                AddClarifyingParenthesesIntention.createReplacementText(unwrappedExpression, out);
                out.append(')');
            } else {
                AddClarifyingParenthesesIntention.createReplacementText(unwrappedExpression, out);
            }
        } else if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceofExpression = (PsiInstanceOfExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = AddClarifyingParenthesesIntention.mightBeConfusingExpression(parent);
            AddClarifyingParenthesesIntention.appendText(instanceofExpression, parentheses, out);
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = AddClarifyingParenthesesIntention.mightBeConfusingExpression(parent);
            AddClarifyingParenthesesIntention.appendText(conditionalExpression, parentheses, out);
        } else if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiElement parent = expression.getParent();
            boolean parentheses = AddClarifyingParenthesesIntention.mightBeConfusingExpression(parent) && !AddClarifyingParenthesesIntention.isSimpleAssignment(assignmentExpression, parent);
            AddClarifyingParenthesesIntention.appendText(assignmentExpression, parentheses, out);
        } else if (expression != null) {
            out.append(expression.getText());
        }
        return out;
    }

    static boolean mightBeConfusingExpression(@Nullable PsiElement element) {
        return element instanceof PsiPolyadicExpression || element instanceof PsiConditionalExpression || element instanceof PsiInstanceOfExpression || element instanceof PsiAssignmentExpression;
    }

    private static boolean isSimpleAssignment(PsiAssignmentExpression assignmentExpression, PsiElement parent) {
        if (!(parent instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression parentAssignmentExpression = (PsiAssignmentExpression)parent;
        IElementType parentTokenType = parentAssignmentExpression.getOperationTokenType();
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        return parentTokenType.equals(tokenType);
    }

    private static void appendText(PsiAssignmentExpression assignmentExpression, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        PsiExpression lhs = assignmentExpression.getLExpression();
        out.append(lhs.getText());
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        out.append(sign.getText());
        PsiExpression rhs = assignmentExpression.getRExpression();
        AddClarifyingParenthesesIntention.createReplacementText(rhs, out);
        if (parentheses) {
            out.append(')');
        }
    }

    private static void appendText(PsiInstanceOfExpression instanceofExpression, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        PsiExpression operand = instanceofExpression.getOperand();
        AddClarifyingParenthesesIntention.createReplacementText(operand, out);
        out.append(" instanceof ");
        PsiTypeElement checkType = instanceofExpression.getCheckType();
        if (checkType != null) {
            out.append(checkType.getText());
        }
        if (parentheses) {
            out.append(')');
        }
    }

    private static void appendText(PsiConditionalExpression conditionalExpression, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        PsiExpression condition = conditionalExpression.getCondition();
        AddClarifyingParenthesesIntention.createReplacementText(condition, out);
        out.append('?');
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        AddClarifyingParenthesesIntention.createReplacementText(thenExpression, out);
        out.append(':');
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        AddClarifyingParenthesesIntention.createReplacementText(elseExpression, out);
        if (parentheses) {
            out.append(')');
        }
    }

    private static void appendText(PsiPolyadicExpression polyadicExpression, boolean parentheses, StringBuilder out) {
        PsiExpression[] operands;
        if (parentheses) {
            out.append('(');
        }
        for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
            PsiJavaToken token;
            if (operand == null) continue;
            if (operand.getType() == PsiType.VOID) {
                throw new ProcessCanceledException();
            }
            if (operands.length == 1) {
                AddClarifyingParenthesesIntention.createReplacementText(operand, out);
            }
            if ((token = polyadicExpression.getTokenBeforeOperand(operand)) != null) {
                PsiElement beforeToken = token.getPrevSibling();
                if (beforeToken instanceof PsiWhiteSpace) {
                    out.append(beforeToken.getText());
                }
                out.append(token.getText());
                PsiElement afterToken = token.getNextSibling();
                if (afterToken instanceof PsiWhiteSpace) {
                    out.append(afterToken.getText());
                }
            }
            if (operands.length == 1) continue;
            AddClarifyingParenthesesIntention.createReplacementText(operand, out);
        }
        if (parentheses) {
            out.append(')');
        }
    }
}

