/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.CreateAssertPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class CreateAssertIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        CreateAssertPredicate createAssertPredicate = new CreateAssertPredicate();
        if (createAssertPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/junit/CreateAssertIntention", "getElementPredicate"));
        }
        return createAssertPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiExpressionStatement statement = (PsiExpressionStatement)element;
        assert (statement != null);
        PsiExpression expression = statement.getExpression();
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
        String specifierString = containingMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)containingMethod, (String)"org.junit.Test", (boolean)true) ? "org.junit.Assert." : "";
        if (BoolUtils.isNegation(expression)) {
            String newExpression = specifierString + "assertFalse(" + BoolUtils.getNegatedExpressionText(expression) + ");";
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newExpression);
        } else if (CreateAssertIntention.isNullComparison(expression)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiExpression comparedExpression = CreateAssertIntention.isNull(lhs) ? rhs : lhs;
            assert (comparedExpression != null);
            String newExpression = specifierString + "assertNull(" + comparedExpression.getText() + ");";
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newExpression);
        } else if (CreateAssertIntention.isEqualityComparison(expression)) {
            PsiExpression comparingExpression;
            PsiExpression comparedExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs instanceof PsiLiteralExpression) {
                comparedExpression = rhs;
                comparingExpression = lhs;
            } else {
                comparedExpression = lhs;
                comparingExpression = rhs;
            }
            assert (comparingExpression != null);
            PsiType type = lhs.getType();
            String newExpression = PsiType.DOUBLE.equals((Object)type) || PsiType.FLOAT.equals((Object)type) ? specifierString + "assertEquals(" + comparedExpression.getText() + ", " + comparingExpression.getText() + ", 0.0);" : (type instanceof PsiPrimitiveType ? specifierString + "assertEquals(" + comparedExpression.getText() + ", " + comparingExpression.getText() + ");" : specifierString + "assertSame(" + comparedExpression.getText() + ", " + comparingExpression.getText() + ");");
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newExpression);
        } else if (CreateAssertIntention.isEqualsExpression(expression)) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression comparedExpression = methodExpression.getQualifierExpression();
            assert (comparedExpression != null);
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression comparingExpression = argList.getExpressions()[0];
            String newExpression = comparingExpression instanceof PsiLiteralExpression ? specifierString + "assertEquals(" + comparingExpression.getText() + ", " + comparedExpression.getText() + ");" : specifierString + "assertEquals(" + comparedExpression.getText() + ", " + comparingExpression.getText() + ");";
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newExpression);
        } else {
            String newExpression = specifierString + "assertTrue(" + expression.getText() + ");";
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newExpression);
        }
    }

    private static boolean isEqualsExpression(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"equals".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] expressions = argList.getExpressions();
        return expressions.length == 1 && expressions[0] != null;
    }

    private static boolean isEqualityComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        return JavaTokenType.EQEQ.equals(tokenType);
    }

    private static boolean isNullComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.EQEQ.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (CreateAssertIntention.isNull(lhs)) {
            return true;
        }
        PsiExpression Rhs = binaryExpression.getROperand();
        return CreateAssertIntention.isNull(Rhs);
    }

    private static boolean isNull(PsiExpression expression) {
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = expression.getText();
        return "null".equals(text);
    }
}

