/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ObscureThrownExceptionsPredicate;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObscureThrownExceptionsIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ObscureThrownExceptionsPredicate obscureThrownExceptionsPredicate = new ObscureThrownExceptionsPredicate();
        if (obscureThrownExceptionsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/ObscureThrownExceptionsIntention", "getElementPredicate"));
        }
        return obscureThrownExceptionsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/exceptions/ObscureThrownExceptionsIntention", "processIntention"));
        }
        if (!(element instanceof PsiReferenceList)) {
            return;
        }
        PsiReferenceList referenceList = (PsiReferenceList)element;
        PsiClassType[] types = referenceList.getReferencedTypes();
        PsiClass commonSuperClass = ObscureThrownExceptionsIntention.findCommonSuperClass(types);
        if (commonSuperClass == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiClassType classType = factory.createType(commonSuperClass);
        PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
        PsiReferenceList newReferenceList = factory.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElement});
        referenceList.replace((PsiElement)newReferenceList);
    }

    @Nullable
    public static PsiClass findCommonSuperClass(PsiClassType ... types) {
        PsiClass aClass1;
        if (types.length == 0) {
            return null;
        }
        PsiClass firstClass = types[0].resolve();
        if (firstClass == null || types.length == 1) {
            return firstClass;
        }
        HashSet<PsiClass> sourceSet = new HashSet<PsiClass>();
        for (PsiClass aClass = firstClass; aClass != null; aClass = aClass.getSuperClass()) {
            sourceSet.add(aClass);
        }
        if (sourceSet.isEmpty()) {
            return null;
        }
        HashSet<PsiClass> targetSet = new HashSet<PsiClass>();
        int max = types.length - 1;
        for (int i = 1; i < max; ++i) {
            PsiClassType classType = types[i];
            for (PsiClass aClass12 = classType.resolve(); aClass12 != null; aClass12 = aClass12.getSuperClass()) {
                if (!sourceSet.contains(aClass12)) continue;
                targetSet.add(aClass12);
            }
            sourceSet = targetSet;
            targetSet = new HashSet();
        }
        for (aClass1 = types[max].resolve(); aClass1 != null && !sourceSet.contains(aClass1); aClass1 = aClass1.getSuperClass()) {
        }
        return aClass1;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiReferenceList referenceList = (PsiReferenceList)element;
        PsiClassType[] types = referenceList.getReferencedTypes();
        PsiClass commonSuperClass = ObscureThrownExceptionsIntention.findCommonSuperClass(types);
        if (commonSuperClass == null) {
            return null;
        }
        return IntentionPowerPackBundle.message("obscure.thrown.exceptions.intention.name", commonSuperClass.getName());
    }
}

