/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.NestedTryStatementsPredicate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MergeNestedTryStatementsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        NestedTryStatementsPredicate nestedTryStatementsPredicate = new NestedTryStatementsPredicate();
        if (nestedTryStatementsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/MergeNestedTryStatementsIntention", "getElementPredicate"));
        }
        return nestedTryStatementsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiCatchSection[] catchSections1;
        PsiCatchSection[] catchSections2;
        PsiCodeBlock tryBlock2;
        PsiCodeBlock tryBlock1;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/exceptions/MergeNestedTryStatementsIntention", "processIntention"));
        }
        PsiTryStatement tryStatement1 = (PsiTryStatement)element.getParent();
        StringBuilder newTryStatement = new StringBuilder("try ");
        PsiResourceList list1 = tryStatement1.getResourceList();
        boolean semicolon = false;
        boolean resourceList = false;
        if (list1 != null) {
            resourceList = true;
            newTryStatement.append('(');
            List variables1 = list1.getResourceVariables();
            for (PsiResourceVariable variable : variables1) {
                if (semicolon) {
                    newTryStatement.append(';');
                } else {
                    semicolon = true;
                }
                newTryStatement.append(variable.getText());
            }
        }
        if ((tryBlock1 = tryStatement1.getTryBlock()) == null) {
            return;
        }
        PsiStatement[] statements = tryBlock1.getStatements();
        if (statements.length != 1) {
            return;
        }
        PsiTryStatement tryStatement2 = (PsiTryStatement)statements[0];
        PsiResourceList list2 = tryStatement2.getResourceList();
        if (list2 != null) {
            if (!resourceList) {
                newTryStatement.append('(');
            }
            resourceList = true;
            List variables2 = list2.getResourceVariables();
            for (PsiResourceVariable variable : variables2) {
                if (semicolon) {
                    newTryStatement.append(';');
                } else {
                    semicolon = true;
                }
                newTryStatement.append(variable.getText());
            }
        }
        if (resourceList) {
            newTryStatement.append(")");
        }
        if ((tryBlock2 = tryStatement2.getTryBlock()) == null) {
            return;
        }
        newTryStatement.append(tryBlock2.getText());
        for (PsiCatchSection section : catchSections2 = tryStatement2.getCatchSections()) {
            newTryStatement.append(section.getText());
        }
        for (PsiCatchSection section : catchSections1 = tryStatement1.getCatchSections()) {
            newTryStatement.append(section.getText());
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiStatement newStatement = factory.createStatementFromText(newTryStatement.toString(), element);
        tryStatement1.replace((PsiElement)newStatement);
    }
}

