/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ExceptionUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.HashSet;
import java.util.Set;

class DetailExceptionsPredicate
implements PsiElementPredicate {
    DetailExceptionsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        IElementType tokenType = ((PsiJavaToken)element).getTokenType();
        if (!JavaTokenType.TRY_KEYWORD.equals(tokenType) && !JavaTokenType.CATCH_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCatchSection) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        if (ErrorUtil.containsError((PsiElement)tryStatement)) {
            return false;
        }
        HashSet<PsiType> exceptionsThrown = new HashSet<PsiType>(10);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            ExceptionUtils.calculateExceptionsThrownForResourceList(resourceList, exceptionsThrown);
        }
        ExceptionUtils.calculateExceptionsThrownForCodeBlock(tryBlock, exceptionsThrown);
        Set<PsiType> exceptionsCaught = ExceptionUtils.getExceptionTypesHandled(tryStatement);
        for (PsiType typeThrown : exceptionsThrown) {
            if (exceptionsCaught.contains(typeThrown)) continue;
            for (PsiType typeCaught : exceptionsCaught) {
                if (!typeCaught.isAssignableFrom(typeThrown)) continue;
                return true;
            }
        }
        return false;
    }
}

