/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.enumswitch;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.enumswitch.EnumSwitchPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateEnumSwitchBranchesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EnumSwitchPredicate enumSwitchPredicate = new EnumSwitchPredicate();
        if (enumSwitchPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/enumswitch/CreateEnumSwitchBranchesIntention", "getElementPredicate"));
        }
        return enumSwitchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiStatement[] statements;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/enumswitch/CreateEnumSwitchBranchesIntention", "processIntention"));
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
            assert (element != null);
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element;
        PsiCodeBlock body = switchStatement.getBody();
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        PsiField[] fields = enumClass.getFields();
        ArrayList<PsiEnumConstant> missingEnumElements = new ArrayList<PsiEnumConstant>(fields.length);
        for (PsiField field : fields) {
            if (!(field instanceof PsiEnumConstant)) continue;
            PsiEnumConstant enumConstant = (PsiEnumConstant)field;
            missingEnumElements.add(enumConstant);
        }
        if (body == null) {
            StringBuilder newStatementText = new StringBuilder();
            newStatementText.append("switch(").append(switchExpression.getText()).append("){");
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                newStatementText.append("case ").append(missingEnumElement.getName()).append(": break;");
            }
            newStatementText.append('}');
            PsiReplacementUtil.replaceStatement((PsiStatement)switchStatement, newStatementText.toString());
            return;
        }
        HashMap<PsiEnumConstant, PsiEnumConstant> nextEnumConstants = new HashMap<PsiEnumConstant, PsiEnumConstant>(fields.length);
        PsiEnumConstant previous = null;
        for (PsiEnumConstant enumConstant : missingEnumElements) {
            if (previous != null) {
                nextEnumConstants.put(previous, enumConstant);
            }
            previous = enumConstant;
        }
        for (PsiStatement statement : statements = body.getStatements()) {
            missingEnumElements.remove(CreateEnumSwitchBranchesIntention.findEnumConstant((PsiElement)statement));
        }
        PsiEnumConstant nextEnumConstant = CreateEnumSwitchBranchesIntention.getNextEnumConstant(nextEnumConstants, missingEnumElements);
        for (PsiElement bodyElement = body.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
            while (nextEnumConstant != null && CreateEnumSwitchBranchesIntention.findEnumConstant(bodyElement) == nextEnumConstant) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore((PsiEnumConstant)missingEnumElements.get(0), bodyElement);
                missingEnumElements.remove(0);
                if (missingEnumElements.isEmpty()) break;
                nextEnumConstant = CreateEnumSwitchBranchesIntention.getNextEnumConstant(nextEnumConstants, missingEnumElements);
            }
            if (!CreateEnumSwitchBranchesIntention.isDefaultSwitchLabelStatement(bodyElement)) continue;
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore(missingEnumElement, bodyElement);
            }
            missingEnumElements.clear();
            break;
        }
        if (!missingEnumElements.isEmpty()) {
            PsiElement lastChild = body.getLastChild();
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore(missingEnumElement, lastChild);
            }
        }
    }

    private static void addSwitchLabelStatementBefore(PsiEnumConstant missingEnumElement, PsiElement anchor) {
        PsiElement parent = anchor.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
        PsiStatement caseStatement = factory.createStatementFromText("case " + missingEnumElement.getName() + ":", anchor);
        parent.addBefore((PsiElement)caseStatement, anchor);
        PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
        parent.addBefore((PsiElement)breakStatement, anchor);
    }

    private static PsiEnumConstant findEnumConstant(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return null;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        PsiExpression value = switchLabelStatement.getCaseValue();
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiEnumConstant)) {
            return null;
        }
        return (PsiEnumConstant)target;
    }

    private static PsiEnumConstant getNextEnumConstant(Map<PsiEnumConstant, PsiEnumConstant> nextEnumConstants, List<PsiEnumConstant> missingEnumElements) {
        PsiEnumConstant nextEnumConstant = nextEnumConstants.get(missingEnumElements.get(0));
        while (missingEnumElements.contains(nextEnumConstant)) {
            nextEnumConstant = nextEnumConstants.get(nextEnumConstant);
        }
        return nextEnumConstant;
    }

    private static boolean isDefaultSwitchLabelStatement(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return false;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        return switchLabelStatement.isDefaultCase();
    }
}

