/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.decls;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.decls.MoveDeclarationPredicate;
import org.jetbrains.annotations.NotNull;

public class MoveDeclarationIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MoveDeclarationPredicate moveDeclarationPredicate = new MoveDeclarationPredicate();
        if (moveDeclarationPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/decls/MoveDeclarationIntention", "getElementPredicate"));
        }
        return moveDeclarationPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiDeclarationStatement newDeclaration;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/decls/MoveDeclarationIntention", "processIntention"));
        }
        PsiLocalVariable variable = (PsiLocalVariable)element;
        PsiReference[] references = (PsiReference[])ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope(), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        PsiCodeBlock tightestBlock = MoveDeclarationPredicate.getTightestBlock(references);
        assert (tightestBlock != null);
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)variable.getParent();
        PsiReference firstReference = references[0];
        PsiElement referenceElement = firstReference.getElement();
        if (tightestBlock.equals(PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiCodeBlock.class))) {
            newDeclaration = MoveDeclarationIntention.moveDeclarationToReference(referenceElement, variable, tightestBlock);
        } else {
            PsiElement child = MoveDeclarationPredicate.getChildWhichContainsElement(tightestBlock, referenceElement);
            newDeclaration = MoveDeclarationIntention.createNewDeclaration(variable, null);
            newDeclaration = (PsiDeclarationStatement)tightestBlock.addBefore((PsiElement)newDeclaration, child);
        }
        assert (declaration != null);
        if (declaration.getDeclaredElements().length == 1) {
            declaration.delete();
        } else {
            variable.delete();
        }
        MoveDeclarationIntention.highlightElement((PsiElement)newDeclaration);
    }

    private static void highlightElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/decls/MoveDeclarationIntention", "highlightElement"));
        }
        Project project = element.getProject();
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Editor editor = editorManager.getSelectedTextEditor();
        EditorColorsScheme globalScheme = editorColorsManager.getGlobalScheme();
        TextAttributes textattributes = globalScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiElement[] elements = new PsiElement[]{element};
        highlightManager.addOccurrenceHighlights(editor, elements, textattributes, true, null);
        StatusBar.Info.set((String)IntentionPowerPackBundle.message("status.bar.escape.highlighting.message", new Object[0]), (Project)project);
    }

    private static PsiDeclarationStatement moveDeclarationToReference(@NotNull PsiElement referenceElement, @NotNull PsiLocalVariable variable, @NotNull PsiCodeBlock block) throws IncorrectOperationException {
        PsiAssignmentExpression assignmentExpression;
        PsiElement referenceParent;
        if (referenceElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/decls/MoveDeclarationIntention", "moveDeclarationToReference"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ipp/decls/MoveDeclarationIntention", "moveDeclarationToReference"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ipp/decls/MoveDeclarationIntention", "moveDeclarationToReference"));
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiStatement.class);
        assert (statement != null);
        if (statement.getParent() instanceof PsiForStatement) {
            statement = (PsiStatement)statement.getParent();
        }
        if ((referenceParent = referenceElement.getParent()) instanceof PsiAssignmentExpression && referenceElement.equals((assignmentExpression = (PsiAssignmentExpression)referenceParent).getLExpression())) {
            PsiDeclarationStatement newDeclaration = MoveDeclarationIntention.createNewDeclaration(variable, assignmentExpression.getRExpression());
            newDeclaration = (PsiDeclarationStatement)block.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
            PsiElement parent = assignmentExpression.getParent();
            assert (parent != null);
            parent.delete();
            return newDeclaration;
        }
        return MoveDeclarationIntention.createNewDeclaration(variable, null);
    }

    private static PsiDeclarationStatement createNewDeclaration(@NotNull PsiLocalVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/decls/MoveDeclarationIntention", "createNewDeclaration"));
        }
        PsiManager manager = variable.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiDeclarationStatement newDeclaration = factory.createVariableDeclarationStatement(variable.getName(), variable.getType(), initializer);
        if (variable.hasModifierProperty("final")) {
            PsiLocalVariable newVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
            PsiModifierList modifierList = newVariable.getModifierList();
            modifierList.setModifierProperty("final", true);
        }
        return newDeclaration;
    }
}

