/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.decls;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.decls.ChangeVariableTypeToRhsTypePredicate;
import org.jetbrains.annotations.NotNull;

public class ChangeVariableTypeToRhsTypeIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ChangeVariableTypeToRhsTypePredicate changeVariableTypeToRhsTypePredicate = new ChangeVariableTypeToRhsTypePredicate();
        if (changeVariableTypeToRhsTypePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/decls/ChangeVariableTypeToRhsTypeIntention", "getElementPredicate"));
        }
        return changeVariableTypeToRhsTypePredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiVariable variable = (PsiVariable)element.getParent();
        PsiExpression initializer = variable.getInitializer();
        assert (initializer != null);
        PsiType type = initializer.getType();
        assert (type != null);
        return IntentionPowerPackBundle.message("change.variable.type.to.rhs.type.intention.name", variable.getName(), type.getPresentableText());
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/decls/ChangeVariableTypeToRhsTypeIntention", "processIntention"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)parent;
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiType type = initializer.getType();
        if (type == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiTypeElement typeElement = factory.createTypeElement(type);
        PsiTypeElement variableTypeElement = variable.getTypeElement();
        if (variableTypeElement == null) {
            return;
        }
        variableTypeElement.replace((PsiElement)typeElement);
    }
}

